import { useQuery} from '@tanstack/react-query';
import axios, { AxiosError } from 'axios';
import { WiresharkOverview, WiresharkScansOverTime } from './types';

export function useWiresharkOverview() {
  return useQuery<WiresharkOverview, AxiosError>({
    queryKey: ['wiresharkOverview'],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/wireshark/overview/`);
      return response.data;
    },
    staleTime: 10000,
  });
}

export function useScansOverTime(date?: string) {
  return useQuery<WiresharkScansOverTime, AxiosError>({
    queryKey: ['scansOverTime', date],
    queryFn: async () => {
      const response = await axios.get(`/api/v1/wireshark/overview/getscanovertime`, {
        params: { date },
      });
      return response.data;
    },
    staleTime: 10000,
  });
}