import {useGetTempFile} from '@/components/wireshark/ringbuffer/queries';
import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageSeparator,
} from '@/components/Page';
import { useTranslation } from "react-i18next";
import { GetRingBuffer } from '@/components/wireshark/ringbuffer/queries';
import RingBufferDataTable from '@/components/wireshark/ringbuffer//RingBufferDataTable';
import { Skeleton } from '@/components/ui/skeleton';
import { Button } from '@/components/ui/button';
import { useDownload } from '@/components/wireshark/ringbuffer/queries';
import { Download } from 'lucide-react';
import { Tooltip, TooltipTrigger, TooltipContent } from "@/components/ui/tooltip";
import { useSearchParams } from 'react-router';


export default function RingBufferViewPackets() {
  const { t } = useTranslation();
  const { data: ringBuffer } = GetRingBuffer();
  const { data: tempFile, isLoading: isLoadingTempFile } = useGetTempFile(Number(ringBuffer && ringBuffer !== 'none' ? ringBuffer.id : 0),);
  const download = useDownload();
  const [params] = useSearchParams();
  const filter = params.get('filter') ?? '';

  const handleDownload = () => {
      download.mutate(tempFile?.merged_file || '');
  };


  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t("Ring Buffer")} </PageTitle>
        {isLoadingTempFile ? (
          <div className="mt-1 flex items-center justify-between w-full">
            <div className="flex items-center space-x-2">
              <Skeleton className="h-6 w-32" />
              <Skeleton className="h-6 w-40" />
              <Skeleton className="h-6 w-40" />
            </div>
            <Skeleton className="h-10 w-10 rounded-lg" />
          </div>
          ) : (
            tempFile?.start_time && tempFile?.end_time && (
              <div className="mt-1 flex items-center justify-between w-full">
                <div className="text-lg font-medium text-muted-foreground mt-1">
                  {t("Time Period")}:{" "}
                  <span className="font-semibold text-foreground">
                    {tempFile.start_time}
                  </span>{" "}
                  -{" "}
                  <span className="font-semibold text-foreground">
                    {tempFile.end_time}
                  </span>
                </div>
                <Tooltip>
                    <TooltipTrigger asChild>
                        <Button
                            size="icon"
                            onClick={handleDownload}
                        >
                            <Download className="w-10 h-10 " />
                        </Button>
                    </TooltipTrigger>
                    <TooltipContent>
                        <p>{t("Download")}</p>
                    </TooltipContent>
                </Tooltip>
              </div>
            )
          )
        }
      </PageHeader>
      <PageSeparator />
       <RingBufferDataTable
        bufferId={tempFile?.id ?? 0 }
        initialFileName={tempFile?.merged_file ?? ""}
        initialFilter={filter} 
      />
    </PageLayout>
  );
}
