import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from "@/components/ui/alert-dialog"
import { Button } from "@/components/ui/button"
import { useTranslation } from "react-i18next";
import { Play } from "lucide-react";
import { useStartRingBuffer } from "@/components/wireshark/ringbuffer/queries";
import { Tooltip, TooltipTrigger, TooltipContent } from "@/components/ui/tooltip";

export function StartRingBufferDialog({ id }: { id: number }) {
  const { t } = useTranslation();
  const startRingBuffer = useStartRingBuffer();
  
  return (
    <AlertDialog>
    <Tooltip>
        <TooltipTrigger asChild>
            <AlertDialogTrigger asChild>
                <Button ><Play /></Button>
            </AlertDialogTrigger>
        </TooltipTrigger>
        <TooltipContent>
            <p>{t("Start Ring Buffer")}</p>
        </TooltipContent>
    </Tooltip>
    <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle>{t("Starting Ring Buffer Will Replace Old Files")}</AlertDialogTitle>
          <AlertDialogDescription>
            {t("Continuing will clear previous ring buffer files and start a new capture cycle.")}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t("Cancel")}</AlertDialogCancel>
          <AlertDialogAction onClick={() => startRingBuffer.mutate(id)}>{t("Continue")}</AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  )
}
