import { StrictMode } from 'react'
import { createRoot } from 'react-dom/client'
import './globals.css'
import App from './App.tsx'
import { BrowserRouter } from 'react-router'
import { ThemeProvider } from '@/contexts/ThemeContext.tsx'
import { QueryClient, QueryClientProvider } from '@tanstack/react-query';
import { AuthProvider } from '@/contexts/AuthContext.tsx';
import { EnvironmentProvider } from '@/contexts/EnvironmentContext.tsx';
import { prefetchIntegrations } from './components/queries.tsx'
import { LanguageProvider } from './contexts/LanguageContext.tsx'

const queryClient = new QueryClient();
prefetchIntegrations(queryClient);

createRoot(document.getElementById('root')!).render(
  <StrictMode>
    <QueryClientProvider client={queryClient}>
      <EnvironmentProvider>
        <ThemeProvider defaultTheme="dark" storageKey="vite-ui-theme">
          <AuthProvider>
            <LanguageProvider>
              <BrowserRouter>
                <App />
              </BrowserRouter>
            </LanguageProvider>
          </AuthProvider>
        </ThemeProvider>
      </EnvironmentProvider>
    </QueryClientProvider>
  </StrictMode>,
)
