import { AlertCircleIcon, Check } from "lucide-react";
import { useTranslation } from "react-i18next";
import {
    PageLayout,
    PageHeader,
    PageTitle,
    PageDescription,
    PageSeparator,
} from "@/components/Page";
import { Alert, AlertTitle } from "@/components/ui/alert";
import type { License } from "@/components/administration/license/types";
import LicenseForm from "@/components/administration/license/LicenseForm";
import { useAuth } from "@/contexts/AuthContext"; 

export default function License() {
  const { t } = useTranslation();
  const { license, trial, isTrialLoading, isUserLoading } = useAuth();

  if (isUserLoading || isTrialLoading) return <div>{t("Loading...")}</div>;

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t("Update License")}</PageTitle>
        <PageDescription>
          {t("Update your Nagios Network Analyzer license key. If you do not have one, you can ")}
          <a
            href="https://www.nagios.com/products/nagios-network-analyzer/buy-now/"
            target="_blank"
            className="text-primary underline"
          >
            {t("purchase one")}
          </a>
          .
        </PageDescription>
      </PageHeader>
      <PageSeparator />
      <div className="w-md max-w-full">
        {license && <LicenseForm license={license} />}

        {license && license.key != null && (
          <Alert variant="ok" className="mt-2 border">
            <Check />
            <AlertTitle>{t("Your license key is valid and up to date!")}</AlertTitle>
          </Alert>
        )}

        {trial && trial.is_trial_license && (
          <Alert variant="destructive" className="mt-2">
            <AlertCircleIcon />
            <AlertTitle>{t('Update your license key. Your trial will end in')} {trial?.trial_days_left} {t('days.')}</AlertTitle>
          </Alert>
        )}
      </div>
    </PageLayout>
  );
}