import { useTranslation } from 'react-i18next';
import { useAuth } from '@/contexts/AuthContext';
import LicenseForm from '@/components/administration/license/LicenseForm';
import NagiosIcon from '@/assets/images/nagios-n.svg';

export default function EnterKey() {
  const { t } = useTranslation();
  const { license, trial, isUserLoading, isTrialLoading } = useAuth();

  if (isUserLoading || isTrialLoading) return <div className="h-screen flex items-center justify-center">{t("Loading...")}</div>;

  // Only show this page if trial expired AND no valid license key
  if (!trial?.trial_expired || (license && license.key)) {
    return <div className="h-screen flex items-center justify-center text-center">{t("You already have a valid license.")}</div>;
  }

  return (
    <div className="h-screen flex flex-col items-center justify-center px-5 gap-6">
      <img src={NagiosIcon} className="absolute left-8 top-8 w-10 h-10" />
      <h2 className="text-4xl font-bold">{t("Enter License Key")}</h2>
      <p className="text-center max-w-md">{t("Your trial has expired. Please enter a valid license key to continue using Nagios Network Analyzer.")}</p>
      <div className="w-full max-w-md p-6 rounded-2xl shadow-lg">
        {license && <LicenseForm license={license} />}
      </div>
    </div>
  );
}
