import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageDescription,
  PageSeparator,
} from "@/components/Page";
import { DataTable } from "@/components/ui/DataTable/DataTable";
import { exampleColumns } from "./columns";
import data from "./data.json";

export default function Example() {
  const dataArray = Object.values(data);
  const actions = [
    {
      label: "Delete",
      value: "delete",
      onClick: async (selectedRows: any) => {
        console.log(selectedRows);
      }
    }
  ]

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>Example Title</PageTitle>
        <PageDescription>Example description that should usually be at least this long</PageDescription>
        <PageSeparator />
      </PageHeader>
      <div  className="pt-4">
        <DataTable
          columns={exampleColumns}
          data={dataArray}
          usesRowSelection={true}
          selectedRowActions={actions}
        />
      </div>
    </PageLayout>
  )
}