import { useTranslation } from "react-i18next";
import {
    Form,
    FormControl,
    FormField,
    FormItem,
    FormLabel,
    FormMessage,
} from "@/components/ui/form"
import { Input } from "@/components/ui/input";
import { Button } from "@/components/ui/button";
import { Link } from "react-router-dom";
import { useForm } from "react-hook-form";
import { Banana, ArrowLeft } from "lucide-react";

export default function ForgotPassword () {
    const { t } = useTranslation();
    const form = useForm({
        defaultValues: {
            userName: "",
        }
    });
    type StringObject = {
        [key: string]: string;
        };
    function onSubmit(values: StringObject) {
        console.log(values);
    }
    return(
        <div className="mx-auto flex flex-col items-center justify-center max-w-md h-full w-full p-4">
            <Banana className="absolute left-8 top-8 text-primary w-36 h-36"/>
            <h2 className="font-medium text-2xl mb-3">{t('Forgot Password')}</h2>
            <div className="my-4 border border-border w-full"></div> {/* spacer */}
            <Form {...form}>
                <form className="w-full flex  flex-col gap-4" onSubmit={form.handleSubmit((onSubmit))}>
                    <FormField 
                        control={form.control}
                        name="userName"
                        render={({ field }) => (
                            <FormItem>
                                <FormLabel className="text-sm font-medium">{t('Username')}</FormLabel>
                                <FormControl>
                                    <Input placeholder="Username" {...field} />
                                </FormControl>
                                <FormMessage />
                            </FormItem>
                        )}
                    />
                    <Button className="bg-primary" type="submit">
                        {t('Send Email')}
                    </Button>
                    <Link className="text-primary flex flex-row gap-4 items-center justify-center" to={"/login"}>
                            <ArrowLeft/>
                            {t('Back to Login')}
                    </Link>
                </form>
            </Form>
        </div>
    );
}