import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageDescription,
} from "@/components/Page"
import { useTranslation } from 'react-i18next';
import { NmapIntegrationUpdatesProvider } from "@/components/nmap/NmapIntegrationUpdatesProvider";
import {
  Tabs,
  TabsContent,
  TabsList,
  TabsTrigger,
} from "@/components/ui/tabs"
import Scans from "@/components/nmap/scans/Scans";
import Ndiffs from "@/components/nmap/ndiffs/Ndiffs";
import Profiles from "@/components/nmap/profiles/Profiles";
import ScheduledScans from "@/components/nmap/scheduledscans/ScheduledScans";
import { useGetScans } from "@/components/nmap/scans/queries";
import { useGetScheduledScans } from "@/components/nmap/scheduledscans/queries";
import { useGetProfiles } from "@/components/nmap/profiles/queries";
import { useGetNdiffs } from "@/components/nmap/ndiffs/queries";
import { useGetNmapVersion } from "@/components/nmap/queries";
import NmapInstall from "@/components/nmap/NmapInstall";
import Overview from "@/components/nmap/overview/Overview";
import { CalendarSearchIcon, CalendarSyncIcon, ClipboardListIcon, FileDiffIcon, ScanIcon, ScanTextIcon, TextSearchIcon } from "lucide-react";

export default function Nmap() {
  const { t } = useTranslation();
  const { data: scansData, isLoading: scansLoading } = useGetScans();
  const { data: scheduledScansData, isLoading: scheduledScansLoading } = useGetScheduledScans();
  const { data: profilesData, isLoading: profilesLoading } = useGetProfiles();
  const { data: ndiffsData, isLoading: ndiffsLoading } = useGetNdiffs();
  const { data: nmapVersion, isLoading: nmapVersionLoading } = useGetNmapVersion();

  const nmapNotInstalled = (!nmapVersion || nmapVersion.nmap_version === 'None') && !nmapVersionLoading;

  return (
    <NmapIntegrationUpdatesProvider>
    <PageLayout>
      <PageHeader>
        <PageTitle>{t('Nmap')}</PageTitle>
        <PageDescription>{t('Run Nmap scan commands, create scan profiles, schedule scans, and create Ndiffs.')}</PageDescription>
      </PageHeader>
      {nmapNotInstalled ? (
        <NmapInstall />
      ) : (
        <Tabs defaultValue="overview" className="full-width pt-6">
          <TabsList >
            <TabsTrigger value="overview" className="gap-1.5">
              <ClipboardListIcon className="w-4 h-4" />
              {t('Overview')}</TabsTrigger>
            <TabsTrigger value="scans" className="gap-1.5">
              <TextSearchIcon className="w-4 h-4" />
              {t('Scans')}</TabsTrigger>
            <TabsTrigger value="scheduledscans" className="gap-1.5">
              <CalendarSearchIcon className="w-4 h-4" />
              {t('Scheduled Scans')}</TabsTrigger>
            <TabsTrigger value="profiles" className="gap-1.5">
              <ScanTextIcon className="w-4 h-4" />
              {t('Profiles')}</TabsTrigger>
            <TabsTrigger value="ndiffs" className="gap-1.5">
              <FileDiffIcon className="w-4 h-4" />
              {t('Ndiffs')}</TabsTrigger>
          </TabsList>
          <TabsContent value="overview">
            <Overview />
          </TabsContent>
          <TabsContent value="scans">
            <Scans 
              data={scansData} 
              isLoading={scansLoading} 
            />
          </TabsContent>
          <TabsContent value="scheduledscans">
            <ScheduledScans 
              data={scheduledScansData} 
              isLoading={scheduledScansLoading} 
            />
          </TabsContent>
          <TabsContent value="profiles">
            <Profiles 
              data={profilesData} 
              isLoading={profilesLoading} 
            />
          </TabsContent>
          <TabsContent value="ndiffs">
            <Ndiffs 
              data={ndiffsData} 
              isLoading={ndiffsLoading} 
            />
          </TabsContent>
        </Tabs>
      )}
    </PageLayout>
    </NmapIntegrationUpdatesProvider>
  )
}