import { useParams, useSearchParams } from "react-router-dom";
import { useTranslation } from "react-i18next";
import { PageLayout, PageHeader, PageTitle } from "@/components/Page";
import { useGetSource } from "@/components/source/queries";
import { Summary } from "@/components/source/Summary";
import { Queries } from "@/components/source/queries/Queries";
import {
  Tabs,
  TabsContent,
  TabsList,
  TabsTrigger,
} from "@/components/ui/tabs";
import { ClipboardListIcon, FileCodeIcon } from "lucide-react";

export default function Source() {
  const { sourceId } = useParams();
  const id = Number(sourceId);
  const { t } = useTranslation();
  const { data, isLoading } = useGetSource(id);

  const [searchParams, setSearchParams] = useSearchParams();
  const tab = searchParams.get("tab") || "summary";

  const handleTabChange = (value: string) => {
    setSearchParams({ tab: value });
  };

  if (isLoading || !data) {
    return (
      <PageLayout>
        <PageHeader>
          <PageTitle>{t("Loading...")}</PageTitle>
        </PageHeader>
      </PageLayout>
    );
  }

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t("Flow Source - " + data.name)}</PageTitle>
      </PageHeader>
      <Tabs value={tab} onValueChange={handleTabChange} className="pt-6">
        <TabsList>
          <TabsTrigger value="summary" className="gap-1.5">
            <ClipboardListIcon className="w-4 h-4" />
            {t("Summary")}
          </TabsTrigger>
          <TabsTrigger value="queries" className="gap-1.5">
            <FileCodeIcon className="w-4 h-4" />
            {t("Queries")}
          </TabsTrigger>
        </TabsList>
        <TabsContent value="summary">
          <Summary data={data} />
        </TabsContent>
        <TabsContent value="queries"><Queries src={Array(data)} /></TabsContent>
      </Tabs>
    </PageLayout>
  );
}
