import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageDescription,
} from "@/components/Page";
import { Tabs, TabsList, TabsContent, TabsTrigger } from "@/components/ui/tabs";
import { useTranslation } from "react-i18next";
import { useCheckSuricata } from "@/components/suricata/queries";
import { SuricataInstall } from "@/components/suricata/SuricataInstall";
import { SuricataOverview } from "@/components/suricata/overview/SuricataOverview";
import { SuricataConfig } from "@/components/suricata/config/SuricataConfig";
import { SuricataRules } from "@/components/suricata/rules/SuricataRules";
import { SuricataRulesets } from "@/components/suricata/rules/rulesets/SuricataRulesets";
import { SuricataAlerts } from "@/components/suricata/alerts/SuricataAlerts";
import { Skeleton } from "@/components/ui/skeleton";
import { SuricataDataTable } from "@/components/suricata/data/SuricataDataTable";
import { useSearchParams } from "react-router";
import { AlertCircleIcon, ClipboardListIcon, ListOrderedIcon, PencilRulerIcon, SquareKanbanIcon } from "lucide-react";

function HasSuricata() {
  const { t } = useTranslation();
  const [searchParams, setSearchParams] = useSearchParams();
  const { data, isLoading, error } = useCheckSuricata();
  const dataFilter = searchParams.get("filter") || "";
  const alertFilter = searchParams.get("alertFilter") || "";
  const activeTab = searchParams.get("tab") || "overview";

  const handleTabChange = (tab: string) => {
    setSearchParams(() => {
      const newParams = new URLSearchParams();
      newParams.set("tab", tab);
      return newParams;
    });
  };

  if (error) {
    console.error(error);
  }

  if (isLoading) {
    return (
      <div>
        <Skeleton className='h-9 w-[500px] my-4' />
        <Skeleton className="h-[600px] w-full rounded-xl" />
      </div>
    )
  }

  if ((!data || data.version === "None") && !isLoading) {
    return (
      <SuricataInstall />
    );
  }
  return (
    <div>
      <Tabs value={activeTab} onValueChange={handleTabChange} className="pt-6">
        <TabsList>
          <TabsTrigger value="overview" className="gap-1.5">
            <ClipboardListIcon className="w-4 h-4" />
            {t("Overview")}
          </TabsTrigger>
          <TabsTrigger value="alerts" className="gap-1.5">
            <AlertCircleIcon className="w-4 h-4" />
            {t("Alerts")}
          </TabsTrigger>
          <TabsTrigger value="data" className="gap-1.5">
            <SquareKanbanIcon className="w-4 h-4" />
            {t("Data")}
          </TabsTrigger>
          <TabsTrigger value="rules" className="gap-1.5">
            <PencilRulerIcon className="w-4 h-4" />
            {t("Modify Rules")}
          </TabsTrigger>
          <TabsTrigger value="rulesets" className="gap-1.5">
            <ListOrderedIcon className="w-4 h-4" />
            {t("Manage Rulesets")}
          </TabsTrigger>
          {/* <TabsTrigger value="config">
            {t("Configuration")}
          </TabsTrigger> */}
        </TabsList>
        <TabsContent value="overview">
          <SuricataOverview />
        </TabsContent>
        <TabsContent value="alerts">
          <SuricataAlerts
            alertFilter={alertFilter}
          />
        </TabsContent>
        <TabsContent value="data">
          <SuricataDataTable initialFilter={dataFilter} />
        </TabsContent>
        <TabsContent value="rules">
          <SuricataRules />
        </TabsContent>
        <TabsContent value="rulesets">
          <SuricataRulesets />
        </TabsContent>
        <TabsContent value="config">
          <SuricataConfig />
        </TabsContent>
      </Tabs>
    </div>
  );
}

export default function Suricata() {
  const { t } = useTranslation();
  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>Suricata</PageTitle>
        <PageDescription>
          {t("View and configure your Suricata instance")}
        </PageDescription>
      </PageHeader>
      <HasSuricata />
    </PageLayout>
  );
}
