import { useMemo } from 'react';
import { useNavigate } from "react-router-dom";
import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageDescription,
  PageSeparator,
} from '@/components/Page';
import { ArrowLeft, ClipboardListIcon, SquareChartGanttIcon } from 'lucide-react';
import { useTranslation } from "react-i18next";
import CaptureDataTable from '@/components/wireshark/captures/CaptureDataTable';
import { Tabs, TabsList, TabsContent, TabsTrigger } from "@/components/ui/tabs";
import CaptureSummary from '@/components/wireshark/capturesummary/CaptureSummary';
export default function Capture() {
  const id = useMemo(() => {
    return window.location.pathname.split('/').filter(Boolean).pop() ?? '';
  }, []);
  const navigate = useNavigate();
  const { t } = useTranslation();

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>Capture ID: {id}</PageTitle>
        <PageDescription>Network traffic packets captured using Wireshark.</PageDescription>
      </PageHeader>
      <PageSeparator />

      <div className="flex w-fit flex-wrap gap-2 mb-6 items-center cursor-pointer hover:text-primary transition-colors duration-300 ease-in-out" onClick={() => navigate('/wireshark/?tab=history')}>
        <ArrowLeft className="w-4 h-4" />
        {t('Back to Capture History')}
      </div>
      <Tabs defaultValue="stats">
        <TabsList >
          <TabsTrigger value="stats" className="w-full gap-1.5">
            <ClipboardListIcon className="w-4 h-4" />
            {t('Capture Summary')}
          </TabsTrigger>
          <TabsTrigger value="capture" className="w-full gap-1.5">
            <SquareChartGanttIcon className="w-4 h-4" />
            {t('Capture Data')}
          </TabsTrigger>
        </TabsList>
        <TabsContent value="stats">
          <CaptureSummary captureId={id} />
        </TabsContent>
        <TabsContent value="capture">
          <CaptureDataTable captureId={id} />
        </TabsContent>
      </Tabs>
    </PageLayout>
  );
}
