import {
  PageLayout,
  PageHeader,
  PageTitle,
  PageDescription,
} from '@/components/Page';
import { Tabs, TabsList, TabsContent, TabsTrigger } from "@/components/ui/tabs";
import { useTranslation } from "react-i18next";
import { WiresharkScan } from '@/components/wireshark/livecapture/WiresharkScan';
import ScanHistoryDataTable from '@/components/wireshark/capturehistory/ScanHistroyDataTable';
import { WiresharkInstall } from '@/components/wireshark/WiresharkInstall';
import { useSearchParams } from 'react-router-dom';
import { useMemo } from 'react';
import { useGetWiresharkVersion } from '@/components/wireshark/queries';
import Overview from '@/components/wireshark/overview/Overview';
import { ClipboardListIcon, FolderClockIcon, TorusIcon, TvMinimalPlayIcon } from 'lucide-react';
import RingBuffer from '@/components/wireshark/ringbuffer/RingBuffer';


export default function Wireshark() {
  const { t } = useTranslation();
  const { data, isLoading } = useGetWiresharkVersion();
  const [searchParams, setSearchParams] = useSearchParams();
  const currentTab = useMemo(() => {
    const tab = searchParams.get('tab');
    return ['overview', 'scan','ringbuffer','history'].includes(tab || '')
      ? tab || undefined
      : 'overview';
  }, [searchParams]);
  const wiresharkNotInstalled = (!data || data === "None") && !isLoading;

  const handleTabChange = (value: string) => {
    setSearchParams({ tab: value });
  };

  return (
    <PageLayout>
      <PageHeader>
        <PageTitle>{t('Wireshark')}</PageTitle>
        <PageDescription>{t('Capture packets on a selected network interface.')}</PageDescription>
      </PageHeader>
      { wiresharkNotInstalled ? (
        <WiresharkInstall/>
      ) : (
        <Tabs value={currentTab} onValueChange={handleTabChange} className='pt-6' >
          <TabsList>
            <TabsTrigger value="overview" className="w-full gap-1.5">
              <ClipboardListIcon className="w-4 h-4" />
              {t('Overview')}
            </TabsTrigger>
            <TabsTrigger value="scan" className="w-full gap-1.5">
              <TvMinimalPlayIcon className="w-4 h-4" />
              {t('Live Capture')}
            </TabsTrigger>
            <TabsTrigger value="ringbuffer" className="w-full gap-1.5">
              <TorusIcon className="w-4 h-4" />
              {t('Ring Buffer')}
            </TabsTrigger>
            <TabsTrigger value="history" className="w-full gap-1.5">
              <FolderClockIcon className="w-4 h-4" />
              {t('Capture History')}
            </TabsTrigger>
          </TabsList>
          <TabsContent value="overview"><Overview /></TabsContent>
          <TabsContent value="scan"> <WiresharkScan /></TabsContent>
          <TabsContent value="ringbuffer"><RingBuffer /></TabsContent>
          <TabsContent value="history"><ScanHistoryDataTable /></TabsContent>
        </Tabs>
      )}
    </PageLayout>
  );
}
