import { RouteObject } from 'react-router';
import Dashboard from './pages/dashboard/Dashboard';
import Sources from './pages/sources/Sources';
import Suricata from './pages/suricata/Suricata.tsx';
import Source from './pages/sources/Source.tsx';
import SourceGroups from './pages/sourcegroups/SourceGroups.tsx'
import SourceGroup from './pages/sourcegroups/SourceGroup.tsx';
import Reports from './pages/reports/Reports.tsx';
import Alerting from './pages/alerting/Alerting.tsx';
import Help from './pages/help/Help.tsx';
import Globals from './pages/administration/Globals.tsx';
import Notifications from './pages/administration/Notifications.tsx';
import Users from './pages/administration/Users.tsx';
import CreateUser from './pages/administration/CreateUser.tsx';
import AuthServers from './pages/administration/AuthServers.tsx';
import License from './pages/administration/License.tsx';
import Backup from './pages/administration/Backup.tsx';
import NotFound from './pages/NotFound.tsx';
import Install from './pages/install/Install.tsx';
import Login from './pages/login/Login.tsx';
import Profile from './pages/profile/Profile.tsx';
import ForgotPassword from './pages/login/ForgotPassword.tsx';
import Nmap from './pages/nmap/Nmap.tsx';
import Example from '@/pages/example/Example.tsx';
import Wireshark from '@/pages/wireshark/Wireshark.tsx';
import Capture from '@/pages/wireshark/Capture.tsx';
import Scan from './pages/nmap/Scan.tsx';
import Ndiff from './pages/nmap/Ndiff.tsx';
import Home from './pages/home/Home.tsx';
import EnterKey from './pages/enterkey/EnterKey.tsx';
import { SuricataDataTable } from './components/suricata/data/SuricataDataTable.tsx';
import RingBufferViewPackets from '@/components/wireshark/ringbuffer/RIngBufferViewPackets.tsx';
// import { lazy, Suspense } from 'react';

// You can use lazy loading for better performance
// const Home = lazy(() => import('./pages/'));
// const About = lazy(() => import('./pages/About'));

type AppRouteObject = RouteObject & {
  category?: string;
  value?: string;
  label?: string;
  isSearchable: boolean;
  adminOnly?:boolean;
}

const routes: AppRouteObject[] = [
  {
    path: '/',
    element: <Home />,
    category: 'General',
    label: 'Home',
    isSearchable: true,
  },
  {
    path: '/example',
    element: <Example />,
    isSearchable: false,
    adminOnly: true,
  },
  {
    path: '/dashboards/:dashboardId',
    element: <Dashboard />,
    isSearchable: false,
  },
  {
    path: '/sources',
    element: <Sources />,
    category: 'Flow Sources',
    label: 'Flow Sources',
    value: 'Flow Data Sources',
    isSearchable: true,
  },
  {
    path: '/suricata',
    element: <Suricata />,
    category: 'Suricata',
    label: 'Suricata',
    isSearchable: true,
  },
  {
    path: '/suricata/data',
    element: <SuricataDataTable />,
    isSearchable: false,
  },
  {
    path: '/sources/:sourceId',
    element: <Source />,
    isSearchable: false,
  },
  {
    path: '/groups',
    element: <SourceGroups />,
    category: 'Flow Source Groups',
    label: 'Flow Source Groups',
    value: 'Flow Data Source Groups',
    isSearchable: true,
  },
  {
    path: '/groups/:groupId',
    element: <SourceGroup />,
    isSearchable: false,
  },
  {
    path: '/reports',
    element: <Reports />,
    category: 'General',
    label: 'Reports',
    isSearchable: true,
  },
  {
    path: '/alerting',
    element: <Alerting />,
    category: 'General',
    label: 'Alerting',
    isSearchable: true,
  },
  {
    path: '/nmap',
    element: <Nmap />,
    category: 'Nmap',
    label: 'Nmap',
    isSearchable: true,
  },
  {
    path: '/nmap/scan/:scanId',
    element: <Scan />,
    isSearchable: false,
  },
  {
    path: '/nmap/ndiff/:ndiffId',
    element: <Ndiff />,
    isSearchable: false,
  },
  {
    path: '/help',
    element: <Help />,
    category: 'General',
    label: 'Help',
    isSearchable: true,
  },
  {
    path: '/admin/globals',
    element: <Globals />,
    category: 'Admin',
    label: 'Global Settings',
    value: 'Admin Global Settings',
    isSearchable: true,
    adminOnly: true,
  },
  {
    path: '/admin/notifications',
    element: <Notifications />,
    category: 'Admin',
    label: 'Notification Settings',
    value: 'Admin Notifications Settings',
    isSearchable: true,
    adminOnly: true,
  },
  {
    path: '/admin/users',
    element: <Users />,
    category: 'Admin',
    label: 'User Management',
    value: 'Admin User Management Settings',
    isSearchable: true,
    adminOnly: true,
  },
  {
    path: '/admin/users/create',
    element: <CreateUser />,
    category: 'Admin',
    label: 'Create User',
    value: 'Admin Create User',
    isSearchable: true,
    adminOnly: true,
  },
  {
    path: '/admin/auth_servers',
    element: <AuthServers />,
    category: 'Admin',
    label: 'AD / LDAP Integration',
    value: 'Admin AD / LDAP Integration Settings',
    isSearchable: true,
    adminOnly: true,
  },
  {
    path: '/admin/license',
    element: <License />,
    category: 'Admin',
    label: 'Update License',
    value: 'Admin Update License',
    isSearchable: true,
    adminOnly: true,
  },
  {
    path: '/admin/backup',
    element: <Backup />,
    category: 'Admin',
    label: 'System Backup',
    value: 'Admin System Backup',
    isSearchable: true,
    adminOnly: true,
  },
  {
    path: '/install',
    element: <Install />,
    isSearchable: false,
  },
  {
    path: '/login',
    element: <Login />,
    isSearchable: false,
  },
  {
    path: '/enterkey',
    element: <EnterKey />,
    isSearchable: false,
  },
  {
    path: '/forgot_password',
    element: <ForgotPassword />,
    isSearchable: false,
  },
  {
    path: '/profile',
    element: <Profile />,
    category: 'General',
    label: 'My Profile',
    value: 'My Profile Settings',
    isSearchable: true,
  },
   {
    path: '/wireshark',
    element: <Wireshark />,
    category: 'Wireshark',
    label: 'Wireshark',
    isSearchable: true,
  },
  {
    path: '/wireshark/:scanId',
    element: <Capture />,
    isSearchable: false,
  },
  {
    path: '/wireshark/ringbuffer',
    element: <RingBufferViewPackets/>,
    category: 'Wireshark',
    label: 'Wireshark Ring Buffer',
    isSearchable: true,
  },
  {
    // Catch-all route for 404 errors
    path: '*',
    element: <NotFound />,
    isSearchable: false,
  }
];

export default routes;