import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from '@tailwindcss/vite';
import path from "path"
import react from '@vitejs/plugin-react';

export default defineConfig({
    plugins: [
        laravel({
            input: ['ui/src/main.tsx'],
            refresh: true,
        }),
        tailwindcss(),
        react(),
    ],
    server: {
        host: '127.0.0.1',
        port: 5173,
    },
    resolve: {
        alias: {
          "@": path.resolve(__dirname, "./ui/src"),
        },
      },
});
