#!/usr/bin/env python3
import unittest
import re
import MySQLdb as mdb
CONFIG = '/var/www/html/nagiosna/config/nagiosna_config.php'

def get_db_info(key, default=None):
    '''Parses the CONFIG file for the $config['db'][key] value and
    returns the value, otherwise it will return default.'''
    TMPL = "\$config\['db'\]\['%s'\]\s*=\s*'(.+)'\s*;\s*" % key
    REGEX = re.compile(TMPL)
    configfile = open(CONFIG, 'r')
    line = configfile.read()
    match = REGEX.search(line)
    configfile.close()
    if match:
        return match.group(1)
    return default

def query_database(query, commit=False):
    global HOSTNAME
    global USERNAME
    global PASSWORD
    global DATABASE
    try:
        connection = mdb.connect(HOSTNAME, USERNAME, PASSWORD, DATABASE)
        cur = connection.cursor()
        cur.execute(query)
        if commit == True:
            connection.commit()
        else:
            result = cur.fetchall()
            cur.close()
            return result
        connection.close()
    except Exception as e:
        raise e

def safe_filename(filename):
    return re.sub('[^A-Za-z_0-9]', '', filename)

HOSTNAME = get_db_info('hostname')
USERNAME = get_db_info('username')
PASSWORD = get_db_info('password')
DATABASE = get_db_info('database')

class Config_Tests(unittest.TestCase):
    
    def test_get_db_info_username(self):
        username = get_db_info('username')
        self.assertTrue(isinstance(username, str))
        self.assertEqual(username, 'nagiosna')
    
    def test_get_db_info_password(self):
        password = get_db_info('password')
        self.assertTrue(isinstance(password, str))
        self.assertEqual(password, 'nagiosna')
    
    def test_get_db_info_database(self):
        database = get_db_info('database')
        self.assertTrue(isinstance(database, str))
        self.assertEqual(database, 'nagiosna')
    
    def test_get_db_info_hostname(self):
        hostname = get_db_info('hostname')
        self.assertTrue(isinstance(hostname, str))
        self.assertEqual(hostname, 'localhost')

if __name__ == "__main__":
    unittest.main()
