#!/bin/bash
#
# Bash script that removes source files
# Copyright 2017-2025 Nagios Enterprises, LLC. All Rights reserved.
#

BACKENDDIR="/usr/local/nagiosna"
SOURCEDIR="$BACKENDDIR/var/$1"
PORT=$2

# Check to make sure source exists
if [ ! -d $SOURCEDIR ]; then
    echo "That source does not seem to exist."
    exit 1
fi

# Remove source files and remove port
rm -rf $SOURCEDIR
$BACKENDDIR/scripts/manage_firewall.sh -p "$PORT" -t udp --rem
