# How to Setup Dev Environment

## **Prerequisite Installation**

### 1. Node
---
#### *Installation*
1. First run the following to retrieve and run the NVM setup script:
    ```
    curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.40.0/install.sh | bash 
    ```

2. Restart your terminal to start using the NVM CLI by running:
    ```
    bash
    ```

3. Finally, install node 22 via NVM with:
    ```
    nvm install 22
    ```

### 2. PHP
---
#### *Installation*
1. Install PHP with the following command:
    ```
    /bin/bash -c "$(curl -fsSL https://php.new/install/linux/8.4)"
    ```

### 3. MYSQL
---
#### *Installation*
1. Install MYSQL by running the following:
    ```
    yum install mysql-server -y
    ```

2. Make sure to start mysql and enable it after installing, with the following commands:
    ```
    systemctl start mysqld
    systemctl enable mysqld
    ```

### 4. Git & GitLab
---
#### *Installation*
1. Install git is installed on your devbox with:
    ```
    yum install git -y
    ```

#### *Setup*
1. Generate an SSH key on your devbox with the following command:
    ```
    ssh-keygen -t ed25519 -C "<comment>"
    ```

2. If prompted, hit enter and take all default options. Once completed, run the following:
    ```
    cat ~/.ssh/id_ed25519.pub
    ```
    This will give you the public key. [Copy the output and add the key to GitLab](https://api.nagios.com/kb/article.php?id=1548).

3. Now we need to update the git config to use your name/nagios email address. Replace with your name/email and run:
    ```
    git config --global user.name "<name>"
    git config --global user.email "<name>@nagios.com"
    ```
4. Clone the repo from gitlab with:
    ```
    git clone git@git.nagios.com:products/nagios-analyzer-next.git
    ```

### Setting up an apache server
1. Run the fullinstall bash script in `/repos/nagios-analyzer-next/`. If this is a development environment there will need to be somethings changed in the fullinstall script. If we are using the laravel bash script above to install php version/composer then we want to comment out line 21 where we are setting the php verison and 122 where we move the file structure to /var/www/html. If this is a development enviornment change 122 with:
    ```
    ln -s /repos/nagios-analyzer-next/nagiosna /var/www/html/nagiosna
    ```
    After we can run the fullinstall with:
    ```
    ./fullinstall
    ```
2. Whenever you make changes that you want to display on a dev environment you will need to build the changes and cp them over to the proper laravel location for it to display. To do so navigate to `/repos/nagios-analyzer-next/nagiosna/ui` from here run:
    ```
    npm run build
    cp -r dist/* ../public/
    ```
3. If you are in a developement environment you'll want to develop locally for the least friction. If you don't you will need to rebuild your jsx everytime you make changes to display them via your apache server due to the interaction with laravel/react and an apache


## **Setup/Configuration**
1. Navigate to: `/repos/nagios-analyzer-next/nagiosna/`
2. To get vendor files before running php artisan serve run:
    ```
    composer update
    composer install
    ```
3. To build vite assets needed for laravel when viewing the laravel backend run these commands:
    ```
    npm i
    npm run build
    ```
4. We need a env file so navigate to the project and run these
    ```
    cp .env.example .env
    php artisan key:generate
    php artisan migrate
    ```
5. To run the project 
    ```
    composer run dev
    ```

## About Laravel

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.

## Learning Laravel

Laravel has the most extensive and thorough [documentation](https://laravel.com/docs) and video tutorial library of all modern web application frameworks, making it a breeze to get started with the framework.

You may also try the [Laravel Bootcamp](https://bootcamp.laravel.com), where you will be guided through building a modern Laravel application from scratch.

If you don't feel like reading, [Laracasts](https://laracasts.com) can help. Laracasts contains thousands of video tutorials on a range of topics including Laravel, modern PHP, unit testing, and JavaScript. Boost your skills by digging into our comprehensive video library.

## Laravel Sponsors

We would like to extend our thanks to the following sponsors for funding Laravel development. If you are interested in becoming a sponsor, please visit the [Laravel Partners program](https://partners.laravel.com).

### Premium Partners

- **[Vehikl](https://vehikl.com/)**
- **[Tighten Co.](https://tighten.co)**
- **[WebReinvent](https://webreinvent.com/)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel/)**
- **[Cyber-Duck](https://cyber-duck.co.uk)**
- **[DevSquad](https://devsquad.com/hire-laravel-developers)**
- **[Jump24](https://jump24.co.uk)**
- **[Redberry](https://redberry.international/laravel/)**
- **[Active Logic](https://activelogic.com)**
- **[byte5](https://byte5.de)**
- **[OP.GG](https://op.gg)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
