<?php

namespace App\Enums;

enum CheckStatusEnum: int
{
    case OK = 0;
    case WARNING = 1;
    case CRITICAL = 2;
    case UNKNOWN = 3;

    /**
     * Get the status name as a string
     */
    public function getName(): string
    {
        return match($this) {
            self::OK => 'OK',
            self::WARNING => 'WARNING',
            self::CRITICAL => 'CRITICAL',
            self::UNKNOWN => 'UNKNOWN',
        };
    }

    /**
     * Get status enum from integer value
     */
    public static function fromValue(int $value): self
    {
        return match($value) {
            0 => self::OK,
            1 => self::WARNING,
            2 => self::CRITICAL,
            3 => self::UNKNOWN,
            default => self::UNKNOWN,
        };
    }

    /**
     * Get status enum from name string
     */
    public static function fromName(string $name): self
    {
        return match(strtoupper($name)) {
            'OK' => self::OK,
            'WARNING' => self::WARNING,
            'CRITICAL' => self::CRITICAL,
            'UNKNOWN' => self::UNKNOWN,
            default => self::UNKNOWN,
        };
    }
}
