<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Broadcasting\ShouldBroadcastNow;
use App\Models\WiresharkCapture;

class PacketCaptured implements ShouldBroadcastNow
{
    use Dispatchable, InteractsWithSockets, SerializesModels;
    /**
     * Create a new event instance.
     */
    public function __construct(public WiresharkCapture $capture)
    {
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
             new PrivateChannel('NNA.Users'),
        ];

    }

    public function broadcastWith(): array
    {
        return [
            'id' => $this->capture->id,
            'interface' =>$this->capture->interface,
            'status' => $this->capture->status,
            'started_at' => $this->capture->started_at,
            'finished_at' => $this->capture->finished_at,
            'pid' => $this->capture->pid,

        ];
    }

}
