<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Report extends Model
{
    public $timestamps = false;
    
    protected $fillable = [
        'name',
        'dashboard_id',
        'schedule_type',
        'schedule_parameters',
        'format',
        'recipients',
        'created_by',
        'enabled',
    ];

    protected $casts = [
        'schedule_parameters' => 'array',
        'recipients' => 'array',
        'enabled' => 'boolean'
    ];

    /**
     * The user that created the report.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * The report recipients.
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class);
    }
}
