<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'flow_source_permissions',
        'suricata_permissions',
        'wireshark_permissions',
        'nmap_permissions',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'flow_source_permissions' => 'array',
            'suricata_permissions' => 'array',
            'wireshark_permissions' => 'array',
            'nmap_permissions' => 'array',
            'protected' => 'boolean',
        ];
    }

    /**
     * The users that belong to this role.
     */
    public function users(): HasMany
    {
        return $this->hasMany(User::class);
    }
}
