<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SnmpReceiver extends Model
{
    public $timestamps = false;

    protected $fillable = [
        'name',
        'version',
        'community_string',
        'auth_level',
        'priv_protocol',
        'priv_password',
        'auth_protocol',
        'auth_password',
        'username',
        'port',
        'ip',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'version' => 'string',
            'port' => 'integer',
        ];
    }
}
