<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SuricataData extends Model
{
    protected $table = "suricata_data";

    protected $fillable = [
        'json_id',
        'interface',
        'timestamp',
        'flow_id',
        'event_type',
        'src_ip',
        'src_port',
        'dest_ip',
        'dest_port',
        'protocol',
        'line_location',
        'signature_id',
    ];

    /**
     * Reference back to the JSON tracking object.
     */
    public function jsonFile()
    {
        return $this->belongsTo(SuricataJson::class, 'json_id');
    }
}
