<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WiresharkCapture extends Model
{
    /**
     * Cast started_at and finished_at into ISO 8601 format.
     */
    protected $casts = [
        'started_at' => 'datetime:Y-m-d\TH:i:s.u\Z',
        'finished_at' => 'datetime:Y-m-d\TH:i:s.u\Z',
    ];

    protected $fillable = [
        'user_id',
        'interface',
        'started_at',
        'finished_at',
        'pid',
        'file_name',
        'status',
    ];

    public $timestamps = false;
}
