export default {
    extends: ['@commitlint/config-conventional'],
    rules: {
        // Type must be one of the following
        'type-enum': [
            2,
            'always',
            [
                'feat', // New feature
                'fix', // Bug fix
                'docs', // Documentation only
                'style', // Formatting, no code change
                'refactor', // Code change that neither fixes a bug nor adds a feature
                'perf', // Performance improvement
                'test', // Adding or updating tests
                'build', // Build system or external dependencies
                'ci', // CI configuration
                'chore', // Other changes that don't modify src or test files
                'revert', // Reverts a previous commit
            ],
        ],
        // Scope is required
        'scope-empty': [2, 'never'],
        'scope-case': [2, 'always', 'lower-case'],
        // Subject (description) rules - all lowercase
        'subject-case': [2, 'always', 'lower-case'],
        'subject-empty': [2, 'never'],
        'subject-max-length': [2, 'always', 72],
        // Type rules
        'type-case': [2, 'always', 'lower-case'],
        'type-empty': [2, 'never'],
        // Header rules
        'header-max-length': [2, 'always', 100],
    },
};

