<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('suricata_rulesets', 'id')) {
            DB::statement("
                ALTER TABLE suricata_rulesets
                DROP PRIMARY KEY,
                ADD COLUMN id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT FIRST,
                ADD UNIQUE KEY suricata_rulesets_name_unique (`name`),
                ADD PRIMARY KEY (`id`)
            ");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('suricata_rulesets', 'id')) {
            DB::statement("
                ALTER TABLE suricata_rulesets
                DROP PRIMARY KEY,
                DROP INDEX IF EXISTS suricata_rulesets_name_unique,
                DROP COLUMN id,
                ADD PRIMARY KEY (`name`)
            ");
        }
    }
};
