<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('suricata_data', function (Blueprint $table) {
            $table->dropColumn('source_file');

            $table->unsignedBigInteger('json_id')->nullable()->after('id');

            $table->foreign('json_id')
                ->references('id')
                ->on('suricata_json')
                ->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('suricata_data', function (Blueprint $table) {
            $table->dropForeign(['json_id']);
            $table->dropColumn('json_id');

            $table->string('source_file', 255)->after('id');
        });
    }
};
