<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('suricata_rulesets', function (Blueprint $table) {
            $table->dropColumn('update_frequency');
        });
        Schema::table('suricata_config', function (Blueprint $table)  {
            $table->string('ruleset_update_interval')->default('daily');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('suricata_rulesets', function (Blueprint $table) {
            $table->string('update_frequency')->default('daily');
        });
        Schema::table('suricata_config', function (Blueprint $table)  {
            $table->dropColumn('ruleset_update_interval');
        });
    }
};
