<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;

class UserRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * This seeder ensures the user role always exists at id=2.
     */
    public function run(): void
    {
        $userRoleData = [
            'id' => 2,
            'name' => 'User',
            'type' => 'user',
            'protected' => true,
            'flow_source_permissions' => [
                'sources' => ['get'],
                'sourcegroups' => ['get'],
                'start_stop_sources' => false,
                'start_stop_sourcegroups' => false,
            ],
            'suricata_permissions' => [
                'rules' => ['get'],
                'rulesets' => ['get'],
                'config' => false,
                'start_stop_scan' => false,
                'data' => ['get'],
                'scan_pcap' => false,
                'alerts' => false,
            ],
            'wireshark_permissions' => [
                'pcaps' => ['get'],
                'ring_buffer' => ['get'],
                'start_stop_capture' => false,
                'start_stop_ring_buffer' => false,
            ],
            'nmap_permissions' => [
                'scans' => ['get'],
                'scheduled_scans' => ['get'],
                'profiles' => ['get'],
                'ndiffs' => ['get'],
            ],
        ];

        $existingRole = Role::where('type', 'user')->first();
        if ($existingRole) {
            $existingRole->update($userRoleData);
        } else {
            Role::create($userRoleData);
        }
    }
}
