<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\NmapScheduledScan;
use App\Models\Report;

class _2026R1_0_1_Seeder extends Seeder
{
    /**
     * Run the database seeds.
     * This seeder updates the schedule types for the NmapScheduledScan and Report models.
     */
    public function run(): void
    {
        NmapScheduledScan::where('schedule_type', 'everyMinute')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '1']]);
        NmapScheduledScan::where('schedule_type', 'everyTwoMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '1']]);
        NmapScheduledScan::where('schedule_type', 'everyThreeMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '5']]);
        NmapScheduledScan::where('schedule_type', 'everyFourMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '5']]);
        NmapScheduledScan::where('schedule_type', 'everyFiveMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '5']]);
        NmapScheduledScan::where('schedule_type', 'everyTenMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '10']]);
        NmapScheduledScan::where('schedule_type', 'everyFifteenMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '15']]);
        NmapScheduledScan::where('schedule_type', 'everyThirtyMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '30']]);
        NmapScheduledScan::where('schedule_type', 'everyOddHour')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        NmapScheduledScan::where('schedule_type', 'everyTwoHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        NmapScheduledScan::where('schedule_type', 'everyThreeHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        NmapScheduledScan::where('schedule_type', 'everyFourHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        NmapScheduledScan::where('schedule_type', 'everySixHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        NmapScheduledScan::where('schedule_type', 'twiceDailyAt')->update(['schedule_type' => 'dailyAt', 'schedule_parameters' => ['time' => '00:00']]);
        NmapScheduledScan::where('schedule_type', 'twiceMonthly')->update(['schedule_type' => 'monthlyOn', 'schedule_parameters' => ['day' => '1', 'time' => '00:00']]);
        NmapScheduledScan::where('schedule_type', 'quarterly')->update(['schedule_type' => 'monthlyOn', 'schedule_parameters' => ['day' => '1', 'time' => '00:00']]);
        NmapScheduledScan::where('schedule_type', 'lastDayOfMonth')->update(['schedule_type' => 'monthlyOn', 'schedule_parameters' => ['day' => '1', 'time' => '00:00']]);
        NmapScheduledScan::where('schedule_type', 'cron')->get()->each(function($scan) {
            $params = $scan->schedule_parameters;
            if (is_array($params) && array_key_exists('expression', $params)) {
                $params['cron'] = $params['expression'];
                unset($params['expression']);
                $scan->schedule_parameters = $params;
                $scan->save();
            }
        });

        Report::where('schedule_type', 'everyMinute')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '1']]);
        Report::where('schedule_type', 'everyTwoMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '1']]);
        Report::where('schedule_type', 'everyThreeMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '5']]);
        Report::where('schedule_type', 'everyFourMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '5']]);
        Report::where('schedule_type', 'everyFiveMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '5']]);
        Report::where('schedule_type', 'everyTenMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '10']]);
        Report::where('schedule_type', 'everyFifteenMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '15']]);
        Report::where('schedule_type', 'everyThirtyMinutes')->update(['schedule_type' => 'every', 'schedule_parameters' => ['x' => '30']]);
        Report::where('schedule_type', 'everyOddHour')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        Report::where('schedule_type', 'everyTwoHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        Report::where('schedule_type', 'everyThreeHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        Report::where('schedule_type', 'everyFourHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        Report::where('schedule_type', 'everySixHours')->update(['schedule_type' => 'hourlyAt', 'schedule_parameters' => ['minute' => '00']]);
        Report::where('schedule_type', 'twiceDailyAt')->update(['schedule_type' => 'dailyAt', 'schedule_parameters' => ['time' => '00:00']]);
        Report::where('schedule_type', 'twiceMonthly')->update(['schedule_type' => 'monthlyOn', 'schedule_parameters' => ['day' => '1', 'time' => '00:00']]);
        Report::where('schedule_type', 'lastDayOfMonth')->update(['schedule_type' => 'monthlyOn', 'schedule_parameters' => ['day' => '1', 'time' => '00:00']]);
        Report::where('schedule_type', 'quarterly')->update(['schedule_type' => 'monthlyOn', 'schedule_parameters' => ['day' => '1', 'time' => '00:00']]);
        Report::where('schedule_type', 'cron')->get()->each(function($report) {
            $params = $report->schedule_parameters;
            if (is_array($params) && array_key_exists('expression', $params)) {
                $params['cron'] = $params['expression'];
                unset($params['expression']);
                $report->schedule_parameters = $params;
                $report->save();
            }
        });
    }
}
