<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\AuthController;
use App\Http\Controllers\Api\V1\InitialInstall;
use App\Http\Controllers\Api\V1\DashboardController;
use App\Http\Controllers\Api\V1\DashletController;
use App\Http\Controllers\Api\V1\UserController;
use App\Http\Controllers\Api\V1\NmapController;
use App\Http\Controllers\Api\V1\NmapScanController;
use App\Http\Controllers\Api\V1\NdiffController;
use App\Http\Controllers\Api\V1\NmapScheduledScanController;
use App\Http\Controllers\Api\V1\NmapProfileController;
use App\Http\Controllers\Api\V1\AuthServerController;
use App\Http\Controllers\Api\V1\CertificateController;
use App\Http\Controllers\Api\V1\NotificationController;
use App\Http\Controllers\Api\V1\SourceController;
use App\Http\Controllers\Api\V1\ReportController;
use App\Http\Controllers\Api\V1\SourceGroupController;
use App\Http\Controllers\Api\V1\CheckController;
use App\Http\Controllers\Api\V1\CommandController;
use App\Http\Controllers\Api\V1\GlobalController;
use App\Http\Controllers\Api\V1\SuricataDataController;
use App\Http\Controllers\Api\V1\SuricataConfigController;
use App\Http\Controllers\Api\V1\SuricataRuleController;
use App\Http\Controllers\Api\V1\SuricataRulesetController;
use App\Http\Controllers\Api\V1\SuricataAlertsController;
use App\Http\Controllers\Api\V1\SuricataScanController;
use App\Http\Controllers\Api\V1\WiresharkController;
use App\Http\Controllers\Api\V1\WiresharkCaptureController;
use App\Http\Controllers\Api\V1\LicenseController;
use App\Http\Controllers\Api\V1\ProfileController;
use App\Http\Controllers\Api\V1\BackupController;
use App\Http\Controllers\Api\V1\EnvironmentController;
use App\Http\Controllers\Api\V1\SystemController;
use App\Http\Controllers\Api\V1\NagiosServerController;
use App\Http\Controllers\Api\V1\ServiceHostnameController;
use App\Http\Controllers\Api\V1\SnmpReceiverController;
use App\Http\Controllers\Api\V1\SearchController;
use App\Http\Controllers\Api\V1\WiresharkRingBufferController;
use App\Http\Controllers\Api\V1\RoleController;
use App\Http\Controllers\Api\V1\LegacyIntegrationController;

Route::prefix('/v1')->group(function () {
    Route::post('/install', InitialInstall::class);
    Route::post('/login', [AuthController::class, 'login']);
    Route::post('/logout', [AuthController::class, 'logout']);

    Route::get('/forgot-password')->middleware('guest')->name('password.request');
    Route::post('/forgot-password', [AuthController::class, 'forgotPassword'])->middleware('guest')->name('password.email');
    Route::get('/reset-password/{token}', [AuthController::class, 'resetPasswordToken'])->middleware('guest')->name('password.reset');
    Route::post('/reset-password', [AuthController::class, 'resetPassword'])->middleware('guest')->name('password.update');

    Route::get('/auth/installed', [AuthController::class, 'installed']);
    Route::get('/environment', [EnvironmentController::class, 'get']);

    Route::get('/system/theme', [SystemController::class, 'getTheme']);
    Route::get('/system/language', [SystemController::class, 'getLanguage']);
    Route::get('/system/time', [SystemController::class, 'getSystemTime']);

    Route::controller(LicenseController::class)->prefix("license")->group(function() {
        Route::get('/', 'get');
    });

    Route::middleware(['auth:sanctum'])->group(function () {
        Route::get('/auth', [AuthController::class, 'get']);

        Route::controller(LicenseController::class)->prefix("license")->group(function() {
            Route::get('/key', 'getKey');
            Route::put('/key', 'putKey');
            Route::patch('/type', 'patchType');
            Route::put('/trial/extend', 'extendTrial');
            Route::post('/activate', 'activateLicense');
        });

        Route::controller(DashboardController::class)->prefix('dashboards')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::patch('/{id}', 'patch');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(DashletController::class)->prefix('dashlets')->group(function () {
            Route::get('/', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(UserController::class)->prefix('users')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
            Route::get("/{id}/language", "getLanguage");
        });

        Route::controller(ProfileController::class)->prefix('profile')->group(function () {
            Route::patch('/personal-information', 'updatePersonalInformation');
            Route::patch('/language', 'updateLanguage');
            Route::patch('/theme', 'updateTheme');
            Route::patch('/password', 'updatePassword');
            Route::patch('/api-key', 'updateAPIKey');
            Route::patch('/default-dashboard/{id}', 'updateDefaultDashboard');
        });

        Route::controller(SourceController::class)->prefix('sources')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id?}', 'delete');
            Route::get('/{id}/summary/chart', 'getSummaryChart');
            Route::get('/summary/chart', 'getSummaryChart');
            Route::get('/{id}/summary/talkers', 'getSummaryTalkers');
            Route::post('/{id}/start', 'start');
            Route::post('/{id}/stop', 'stop');
            Route::post('/{id}/restart', 'restart');
            Route::post('/{id}/status', 'status');
            Route::post('/queries/run', 'postQuery');
        });

        Route::controller(SourceGroupController::class)->prefix('source-groups')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id?}', 'delete');
            Route::get('/{id}/summary/chart', 'getSourceGroupSummaryChart');
            Route::get('/summary/chart', 'getSourceGroupSummaryChart');
            Route::get('/{id}/summary/talkers', 'getSourceGroupSummaryTalkers');
            Route::post('/{id}/start', 'start');
            Route::post('/{id}/stop', 'stop');
            Route::post('/{id}/restart', 'restart');
        });

        Route::controller(SystemController::class)->prefix('system')->group(function () {
            Route::prefix('status')->group(function () {
                Route::get('/cpu', 'getCpuStatus');
                Route::get('/memory', 'getMemoryStatus');
                Route::get('/root-drive', 'getRootDriveStatus');
            });
            Route::get('/product-info', 'getProductInfo');
            Route::get('/update-check', 'getUpdateCheck');
            Route::get('/installed-integrations', 'getInstalledIntegrations');
            Route::get('/whois', 'getWhois');
            Route::get('/reverse-dns', 'getReverseDNS');
        });  

        Route::controller(ReportController::class)->prefix('reports')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::patch('/{id}', 'patch');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(RoleController::class)->prefix('roles')->group(function () {
            Route::get('/{type?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });
        
        Route::controller(CheckController::class)->prefix('checks')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
            Route::post('/{id}/force', 'force');
            Route::patch('/{id}/toggle', 'toggle');
        });

        Route::controller(CommandController::class)->prefix('commands')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(NagiosServerController::class)->prefix('nagios-servers')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(ServiceHostnameController::class)->prefix('service-hostnames')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::controller(SnmpReceiverController::class)->prefix('snmp-receivers')->group(function () {
            Route::get('/{id?}', 'get');
            Route::post('/', 'post');
            Route::put('/{id}', 'put');
            Route::delete('/{id}', 'delete');
        });

        Route::prefix('nmap')->group(function () {
            Route::controller(NmapController::class)->group(function () {
                Route::get('/version', 'getVersion');
                Route::get('/overview', 'getOverview');
            });

            Route::controller(NmapScanController::class)->prefix('scans')->group(function () {
                Route::get('/{id?}', 'get');
                Route::post('/', 'post');
                Route::delete('/{id?}', 'delete');
                Route::get('/{filename}/download', 'download');
                Route::post('/{id}/stop', 'stop');
                Route::get('/{id}/statistics', 'getStatistics');
            });

            Route::controller(NmapScheduledScanController::class)->prefix('scheduled-scans')->group(function () {
                Route::get('/{id?}', 'get');
                Route::post('/', 'post');
                Route::put('/{id}', 'put');
                Route::delete('/{id?}', 'delete');
                Route::get('/{id}/chart', 'getScheduledScanChartData');
            });

            Route::controller(NmapProfileController::class)->prefix('profiles')->group(function () {
                Route::get('/{id?}', 'get');
                Route::post('/', 'post');
                Route::put('/{id}', 'put');
                Route::delete('/{id?}', 'delete');
            });

            Route::controller(NdiffController::class)->prefix('ndiffs')->group(function () {
                Route::get('/{id?}', 'get');
                Route::post('/', 'post');
                Route::delete('/{id?}', 'delete');
                Route::get('/{filename}/download', 'download');
            });
        });

        Route::controller(AuthServerController::class)->prefix('auth-servers')->group(function () {
            Route::get('/', 'get');
            Route::post('/', 'post');
            Route::put('/', 'put');
            Route::delete('/{id}', 'delete');
            Route::post('/validate', 'validate');
            Route::post('/import', 'importUsers');
            Route::post('/query', 'queryAuthServer');
        });

        Route::controller(CertificateController::class)->prefix("certificates")->group(function () {
            Route::get('/', 'get');
            Route::post('/', 'post'); 
            Route::delete('/{id}', 'delete');
            Route::post('/parse', 'parse');
        });

        Route::controller(BackupController::class)->prefix('backups')->group(function () {
            Route::get('/', 'get');
            Route::post('/', 'post');
            Route::delete('/{filename}',  'delete'); 
            Route::get('/{filename}/download', 'download');
        });

        Route::prefix('administration')->group(function () {
            Route::get('/global', [GlobalController::class, 'get']);
            Route::put('/global', [GlobalController::class, 'put']);
            Route::get('/notifications', [NotificationController::class, 'get']);
            Route::post('/notifications', [NotificationController::class, 'test']);
            Route::put('/notifications', [NotificationController::class, 'put']);
        });

        Route::prefix('wireshark')->group(function () {
            Route::controller(WiresharkController::class)->group(function () {
                Route::get('/interfaces', 'getInterfaces');
                Route::get('/version', 'getVersion');
                Route::get('/latest-capture', 'getLatestCapture');
                Route::get('/overview', 'getOverview');
                Route::get('/packet-details', 'getPacketDetails');
                Route::get('/captures-over-time', 'getCapturesOverTime');
                Route::get('/captures-metrics', 'getCapturesMetrics');
            });

            Route::controller(WiresharkCaptureController::class)->prefix('captures')->group(function () {
                Route::get('/','get');
                Route::post('/', 'post');
                Route::post('/import', 'import');
                Route::delete('/{id?}','delete');
                Route::post('/{id}/stop', 'stop');
                Route::get('/{id}/download','download');
                Route::post('/{id}/scan-with-suricata','scanWithSuricata');
                Route::get('/{id}/packets', 'getPackets');
                Route::get('/{id}/info', 'getCaptureInfo');
                Route::get('/{id}/top-talkers', 'getTopTalkers');
                Route::get('/{id}/protocol-statistics', 'getProtocolStatistics');
                Route::get('/{id}/packet-size-distribution', 'getPacketSizeDistribution');
            });

            Route::controller(WiresharkRingBufferController::class)->prefix('ring-buffers')->group(function () {
                Route::get('/{id?}', 'get');
                Route::post('/','post');
                Route::put('/{id}','put');
                Route::post('/{id}/start', 'start');
                Route::post('/{id}/stop', 'stop');
                Route::get('/{id}/packets','getPackets');
                Route::get('/{id}/merged-pcap','getMergedPcap');
                Route::get('/{id}/download', 'download');
            });
        });

        Route::prefix('suricata')->group(function () {
            Route::controller(SuricataScanController::class)->group(function () {
                Route::get('/', 'get');
                Route::post('/', 'post');
                Route::post('/is-running', 'isRunning');
                Route::get('/interfaces', 'getInterfaces');
            });

            Route::controller(SuricataDataController::class)->prefix('data')->group(function () {
                Route::get('/', 'get');
                Route::get('/full-log-json', 'getFullLogJson');
                Route::post('/import-pcap', 'importPcap');
                Route::get('/json-files', 'getJsonFiles');
                Route::delete('/{filename}', 'delete');
            });

            Route::controller(SuricataConfigController::class)->prefix('config')->group(function () {
                Route::get('/', 'get');
                Route::put('/', 'put');
                Route::get('/version', 'getVersion');
            });

            Route::controller(SuricataRuleController::class)->prefix('rules')->group(function () {
                Route::get('/', 'getRules');
                Route::get('/files', 'getAllRulesFiles');
                Route::delete('/files', 'deleteRuleFile');
                Route::get('/{sid}', 'getRule');
                Route::put('/', 'put');
                Route::delete('/{sid?}', 'delete');
                Route::post('/import', 'import');
                Route::patch('/toggle', 'toggle');
                Route::patch('/{sid}/toggle', 'toggle');
            });

            Route::controller(SuricataRulesetController::class)->prefix('rulesets')->group(function () {
                Route::get('/', 'getRulesets');
                Route::post('/', 'post');
                Route::get('/{id}', 'getRuleset');
                Route::put('/{id}', 'put');
                Route::patch('/{id}', 'patch');
                Route::delete('/{id?}', 'delete');
            });

            Route::controller(SuricataAlertsController::class)->prefix('alerts')->group(function () {
                Route::get('/', 'get');
                Route::get('/total', 'getTotalWeeklyAlerts');
                Route::get('/categories', 'getCategories');
                Route::get('/severities', 'getSeverities');
                Route::get('/top', 'getTopAlerts');
            });
        });

        Route::controller(SearchController::class)->prefix('search')->group(function () {
            Route::get('/', 'get');
        });

        Route::get('/graphs/execute', [LegacyIntegrationController::class, 'execute']);
    });
});

// Route for auth:sanctum to redirect to when an API token is not provided
Route::get('/unauthorized', function () {
    return response()->json([
        'message' => ' Unauthorized.',
    ], 401);
})->name('login');
