<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\ExportController;

Route::prefix('/api/v1')->group(function () {
    Route::middleware(['auth:sanctum'])->group(function () {
        Route::controller(ExportController::class)->prefix('export')->group(function () {
            Route::get('/login', 'login');
            Route::get('/', 'get');
            Route::post('/{id}', 'post');
        });
    });
});

Route::get('/{any}', function () {
    return view('app');
})->where('any', '.*');
