import { Route, RouteObject, Routes } from 'react-router-dom';
import './App.css';
import routes from './routes';
import { configureEcho } from '@laravel/echo-react';
import axios from '@/lib/axios';
import { useEnvironment } from '@/contexts/EnvironmentContext';
import { useEffect, useState } from 'react';

function App() {
  const { environment } = useEnvironment();
  const [echoReady, setEchoReady] = useState(false);

  useEffect(() => {
    if (environment?.reverbAppKey !== undefined) {
      configureEcho({
        broadcaster: 'reverb',
        key: environment.reverbAppKey,
        wsHost: window.location.hostname,
        wsPort: 8080,
        wssPort: 8080,
        forceTLS: false,
        enabledTransports: ['ws', 'wss'],
        authorizer: (channel) => {
          return {
            authorize: (socketId, callback) => {
              axios
                .post('/api/broadcasting/auth', {
                  socket_id: socketId,
                  channel_name: channel.name,
                })
                .then((response) => callback(null, response.data))
                .catch((error) => callback(new Error('Failed to get environment.'), error));
            },
          };
        },
      });
      setEchoReady(true);
    }
  }, [environment?.reverbAppKey]);

  if (!echoReady) return <></>;

  const renderRoutes = (routes: RouteObject[]) =>
    routes.map((route) => {
      if (route.children) {
        return (
          <Route key={route.path} path={route.path} element={route.element}>
            {renderRoutes(route.children)}
          </Route>
        );
      }
      return <Route key={route.path} path={route.path} element={route.element} />;
    });

  return <Routes>{renderRoutes(routes)}</Routes>;
}

export default App;
