import { Select, SelectContent, SelectGroup, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { ControllerRenderProps } from 'react-hook-form';
import { ConfigOptions } from '@/components/administration/types';

type TimeZoneDropdownField = ControllerRenderProps<ConfigOptions, 'timezone'>;

export function TimeZoneDropdown(field: TimeZoneDropdownField) {
  const timezones = [
    { label: '(UTC-11:00) Midway Island', value: 'Pacific/Midway' },
    { label: '(UTC-10:00) Hawaii', value: 'Pacific/Honolulu' },
    { label: '(UTC-09:00) Alaska', value: 'America/Anchorage' },
    { label: '(UTC-08:00) Pacific Time (US & Canada)', value: 'America/Los_Angeles' },
    { label: '(UTC-08:00) Tijuana', value: 'America/Tijuana' },
    { label: '(UTC-07:00) Chihuahua', value: 'America/Chihuahua' },
    { label: '(UTC-07:00) Mazatlan', value: 'America/Mazatlan' },
    { label: '(UTC-06:00) Central Time (US & Canada)', value: 'America/Managua' },
    { label: '(UTC-06:00) Chicago', value: 'America/Chicago' },
    { label: '(UTC-06:00) Mexico City', value: 'America/Mexico_City' },
    { label: '(UTC-06:00) Monterrey', value: 'America/Monterrey' },
    { label: '(UTC-05:00) New York', value: 'America/New_York' },
    { label: '(UTC-05:00) Eastern Time (US & Canada)', value: 'America/Jamaica' },
    { label: '(UTC-05:00) Bogota', value: 'America/Bogota' },
    { label: '(UTC-05:00) Lima', value: 'America/Lima' },
    { label: '(UTC-04:30) Caracas', value: 'America/Caracas' },
    { label: '(UTC-04:00) La Paz', value: 'America/La_Paz' },
    { label: '(UTC-04:00) Santiago', value: 'America/Santiago' },
    { label: '(UTC-03:00) Brasilia', value: 'America/Sao_Paulo' },
    { label: '(UTC-03:00) Buenos Aires', value: 'America/Argentina/Buenos_Aires' },
    { label: '(UTC-02:00) Mid-Atlantic', value: 'America/Noronha' },
    { label: '(UTC-01:00) Azores', value: 'Atlantic/Azores' },
    { label: '(UTC-01:00) Cape Verde Is.', value: 'Atlantic/Cape_Verde' },
    { label: '(UTC+00:00) Casablanca', value: 'Africa/Casablanca' },
    { label: '(UTC+00:00) London', value: 'Europe/London' },
    { label: '(UTC+00:00) Lisbon', value: 'Europe/Lisbon' },
    { label: '(UTC+00:00) Monrovia', value: 'Africa/Monrovia' },
    { label: '(UTC+00:00) UTC', value: 'UTC' },
    { label: '(UTC+01:00) Amsterdam', value: 'Europe/Amsterdam' },
    { label: '(UTC+01:00) Belgrade', value: 'Europe/Belgrade' },
    { label: '(UTC+01:00) Berlin', value: 'Europe/Berlin' },
    { label: '(UTC+01:00) Bratislava', value: 'Europe/Bratislava' },
    { label: '(UTC+01:00) Brussels', value: 'Europe/Brussels' },
    { label: '(UTC+01:00) Budapest', value: 'Europe/Budapest' },
    { label: '(UTC+01:00) Copenhagen', value: 'Europe/Copenhagen' },
    { label: '(UTC+01:00) Ljubljana', value: 'Europe/Ljubljana' },
    { label: '(UTC+01:00) Madrid', value: 'Europe/Madrid' },
    { label: '(UTC+01:00) Paris', value: 'Europe/Paris' },
    { label: '(UTC+01:00) Prague', value: 'Europe/Prague' },
    { label: '(UTC+01:00) Rome', value: 'Europe/Rome' },
    { label: '(UTC+01:00) Sarajevo', value: 'Europe/Sarajevo' },
    { label: '(UTC+01:00) Skopje', value: 'Europe/Skopje' },
    { label: '(UTC+01:00) Stockholm', value: 'Europe/Stockholm' },
    { label: '(UTC+01:00) Vienna', value: 'Europe/Vienna' },
    { label: '(UTC+01:00) Warsaw', value: 'Europe/Warsaw' },
    { label: '(UTC+01:00) West Central Africa', value: 'Africa/Lagos' },
    { label: '(UTC+01:00) Zagreb', value: 'Europe/Zagreb' },
    { label: '(UTC+02:00) Athens', value: 'Europe/Athens' },
    { label: '(UTC+02:00) Bucharest', value: 'Europe/Bucharest' },
    { label: '(UTC+02:00) Cairo', value: 'Africa/Cairo' },
    { label: '(UTC+02:00) Harare', value: 'Africa/Harare' },
    { label: '(UTC+02:00) Helsinki', value: 'Europe/Helsinki' },
    { label: '(UTC+02:00) Istanbul', value: 'Europe/Istanbul' },
    { label: '(UTC+02:00) Jerusalem', value: 'Asia/Jerusalem' },
    { label: '(UTC+02:00) Pretoria', value: 'Africa/Johannesburg' },
    { label: '(UTC+02:00) Riga', value: 'Europe/Riga' },
    { label: '(UTC+02:00) Sofia', value: 'Europe/Sofia' },
    { label: '(UTC+02:00) Tallinn', value: 'Europe/Tallinn' },
    { label: '(UTC+02:00) Vilnius', value: 'Europe/Vilnius' },
    { label: '(UTC+03:00) Baghdad', value: 'Asia/Baghdad' },
    { label: '(UTC+03:00) Kuwait', value: 'Asia/Kuwait' },
    { label: '(UTC+03:00) Minsk', value: 'Europe/Minsk' },
    { label: '(UTC+03:00) Nairobi', value: 'Africa/Nairobi' },
    { label: '(UTC+03:00) Riyadh', value: 'Asia/Riyadh' },
    { label: '(UTC+03:00) Volgograd', value: 'Europe/Volgograd' },
    { label: '(UTC+03:30) Tehran', value: 'Asia/Tehran' },
    { label: '(UTC+04:00) Abu Dhabi', value: 'Asia/Muscat' },
    { label: '(UTC+04:00) Baku', value: 'Asia/Baku' },
    { label: '(UTC+04:00) Moscow', value: 'Europe/Moscow' },
    { label: '(UTC+04:00) Tbilisi', value: 'Asia/Tbilisi' },
    { label: '(UTC+04:00) Yerevan', value: 'Asia/Yerevan' },
    { label: '(UTC+04:30) Kabul', value: 'Asia/Kabul' },
    { label: '(UTC+05:00) Islamabad', value: 'Asia/Karachi' },
    { label: '(UTC+05:00) Tashkent', value: 'Asia/Tashkent' },
    { label: '(UTC+05:30) Kolkata', value: 'Asia/Kolkata' },
    { label: '(UTC+06:00) Almaty', value: 'Asia/Almaty' },
    { label: '(UTC+06:00) Dhaka', value: 'Asia/Dhaka' },
    { label: '(UTC+06:00) Ekaterinburg', value: 'Asia/Yekaterinburg' },
    { label: '(UTC+07:00) Bangkok', value: 'Asia/Bangkok' },
    { label: '(UTC+07:00) Jakarta', value: 'Asia/Jakarta' },
    { label: '(UTC+07:00) Novosibirsk', value: 'Asia/Novosibirsk' },
    { label: '(UTC+08:00) Beijing', value: 'Asia/Hong_Kong' },
    { label: '(UTC+08:00) Krasnoyarsk', value: 'Asia/Krasnoyarsk' },
    { label: '(UTC+08:00) Kuala Lumpur', value: 'Asia/Kuala_Lumpur' },
    { label: '(UTC+08:00) Perth', value: 'Australia/Perth' },
    { label: '(UTC+08:00) Singapore', value: 'Asia/Singapore' },
    { label: '(UTC+08:00) Taipei', value: 'Asia/Taipei' },
    { label: '(UTC+08:00) Urumqi', value: 'Asia/Urumqi' },
    { label: '(UTC+09:00) Irkutsk', value: 'Asia/Irkutsk' },
    { label: '(UTC+09:00) Seoul', value: 'Asia/Seoul' },
    { label: '(UTC+09:00) Tokyo', value: 'Asia/Tokyo' },
    { label: '(UTC+09:30) Adelaide', value: 'Australia/Adelaide' },
    { label: '(UTC+09:30) Darwin', value: 'Australia/Darwin' },
    { label: '(UTC+10:00) Brisbane', value: 'Australia/Brisbane' },
    { label: '(UTC+10:00) Guam', value: 'Pacific/Guam' },
    { label: '(UTC+10:00) Hobart', value: 'Australia/Hobart' },
    { label: '(UTC+10:00) Melbourne', value: 'Australia/Melbourne' },
    { label: '(UTC+10:00) Port Moresby', value: 'Pacific/Port_Moresby' },
    { label: '(UTC+10:00) Sydney', value: 'Australia/Sydney' },
    { label: '(UTC+10:00) Yakutsk', value: 'Asia/Yakutsk' },
    { label: '(UTC+11:00) Vladivostok', value: 'Asia/Vladivostok' },
    { label: '(UTC+12:00) Auckland', value: 'Pacific/Auckland' },
    { label: '(UTC+12:00) Fiji', value: 'Pacific/Fiji' },
    { label: '(UTC+12:00) International Date Line West', value: 'Pacific/Kwajalein' },
    { label: '(UTC+12:00) Kamchatka', value: 'Asia/Kamchatka' },
    { label: '(UTC+12:00) Magadan', value: 'Asia/Magadan' },
    { label: "(UTC+13:00) Nuku'alofa", value: 'Pacific/Tongatapu' },
  ];

  return (
    <>
      <Select
        value={field.value}
        onValueChange={(selectedVal) => {
          field.onChange(selectedVal);
        }}
      >
        <SelectTrigger className="w-full">
          <SelectValue placeholder="Select a timezone" />
        </SelectTrigger>
        <SelectContent>
          <SelectGroup className="max-h-80 w-full">
            {timezones.map((tz, index) => {
              return (
                <SelectItem key={index} value={tz.value}>
                  {tz.label}
                </SelectItem>
              );
            })}
          </SelectGroup>
        </SelectContent>
      </Select>
    </>
  );
}
