import { AddDashletDialog } from '@/components/dashboard/dashlet/AddEditDashletDialog';
import { CirclePlus } from 'lucide-react';

export default function AddDashletPlaceholder({ dashboardId }: { dashboardId: number }) {
  return (
    <AddDashletDialog dashboardId={dashboardId}>
      <div
        key={dashboardId}
        className="group/placeholder animate-in fade-in-50 zoom-in-95 relative flex h-[390px] w-[646px] items-center justify-center rounded-xl hover:cursor-pointer"
      >
        <svg
          className="stroke-foreground absolute inset-0 z-0 size-full overflow-visible opacity-40 transition-opacity group-hover/placeholder:opacity-100"
          xmlns="http://www.w3.org/2000/svg"
        >
          <rect width="100%" height="100%" fill="none" strokeWidth="1" strokeDasharray="6,8" rx="16" ry="16" />
        </svg>
        <CirclePlus className="size-10 opacity-40 transition-opacity group-hover/placeholder:opacity-100" />
      </div>
    </AddDashletDialog>
  );
}
