import { dashboard } from '@/components/dashboard/types';
import { Button } from '@/components/ui/button';
import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogFooter,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
} from '@/components/ui/dialog';
import { Input } from '@/components/ui/input';
import { Form, FormLabel, FormControl, FormField, FormItem } from '@/components/ui/form';
import { useForm, SubmitHandler } from 'react-hook-form';
import React, { useState } from 'react';
import { useTranslation } from 'react-i18next';
import { useAddDashboard } from '@/components/dashboard/queries';

type AddEditDashboardDialogProps = {
  dashboard?: dashboard;
  userId?: number;
  children: React.ReactNode;
};

export default function AddEditDashboardDialog({ dashboard, userId, children }: AddEditDashboardDialogProps) {
  const [open, setOpen] = useState(false);
  const { t } = useTranslation();
  const addDashboardMutation = useAddDashboard();

  const form = useForm<dashboard>({
    defaultValues: {
      id: dashboard ? dashboard.id : -1,
      title: dashboard ? dashboard.title : '',
      icon: dashboard ? dashboard.icon : 'layout-dashboard',
      range: dashboard ? dashboard.range : '-2 hour',
      refresh_rate: dashboard ? dashboard.refresh_rate : 300000,
    },
  });

  const onSubmit: SubmitHandler<dashboard> = (data) => {
    if (dashboard) {
      console.log(data);
    } else {
      addDashboardMutation.mutate({ ...data, user_id: userId }, { onSuccess: () => setOpen(false) });
    }
  };

  return (
    <Dialog open={open} onOpenChange={setOpen}>
      <DialogTrigger asChild>
        <div>{children}</div>
      </DialogTrigger>
      <DialogContent className="sm:max-w-[425px]">
        <DialogHeader>
          <DialogTitle>{dashboard ? t('Edit Dashboard') : t('Add Dashboard')}</DialogTitle>
          {!dashboard && (
            <DialogDescription>{t('Use this to add a new dashboard to your Dashboards page')}</DialogDescription>
          )}
        </DialogHeader>
        <Form {...form}>
          <form onSubmit={form.handleSubmit(onSubmit)} className="grid gap-4 py-2">
            <FormField
              control={form.control}
              name="title"
              render={({ field }) => (
                <FormItem className="grid grid-cols-4 items-center gap-4 space-y-0">
                  <FormLabel className="text-right">{t('Title')}</FormLabel>
                  <FormControl>
                    <Input {...field} className="border-border col-span-3" />
                  </FormControl>
                </FormItem>
              )}
            />
            <DialogFooter>
              <Button type="submit" className="justify-end">
                {t('Submit')}
              </Button>
            </DialogFooter>
          </form>
        </Form>
      </DialogContent>
    </Dialog>
  );
}
