import { useDeleteDashboard } from '@/components/dashboard/queries';
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from '@/components/ui/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';
import { useGetReports } from '@/components/report/queries';
import { Link } from 'react-router-dom';

export default function DeleteDashboardDialog({ id, children }: { id: number; children: React.ReactNode }) {
  const { t } = useTranslation();
  const deleteDashboard = useDeleteDashboard();
  const { data: reports } = useGetReports();
  const numReports = reports ? reports.filter((report) => report.dashboard_id === id).length : 0;

  return (
    <AlertDialog>
      <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle>{t('Confirm Dashboard Deletion')}</AlertDialogTitle>
          <AlertDialogDescription>
            {t('Are you sure you want to delete this dashboard?')}
            {numReports > 0 && (
              <span>
                {t('Doing so will delete ')}
                <Link
                  className="text-primary hover:underline"
                  to="/reports"
                >{`${numReports} ${t('associated reports')}`}</Link>
                .
              </span>
            )}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
          <AlertDialogAction onClick={() => deleteDashboard.mutate(id)}>{t('Delete')}</AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
}
