import { useTranslation } from 'react-i18next';
import { Alert, AlertDescription, AlertTitle } from '@/components/ui/alert';
import { Terminal } from 'lucide-react';

export default function NoDataAlert() {
  const { t } = useTranslation();

  return (
    <div className="flex size-full items-center justify-center">
      <Alert variant="destructive" className="w-fit">
        <Terminal />
        <AlertTitle>{t('No Data Found')}</AlertTitle>
        <AlertDescription>{t("Try adjusting your dashboard's time range or your dashlet options.")}</AlertDescription>
      </Alert>
    </div>
  );
}
