import { LucideIcon } from 'lucide-react';
import React from 'react';
import type { DashletDataOptions } from '@/components/dashboard/types';

type DashletMeta = {
  name: string;
  title: string;
  description: string;
  icon: LucideIcon;
  component: React.ComponentType<DashletDataOptions>;
};

const dashletModules = import.meta.glob<{ meta: DashletMeta; default: React.ComponentType<DashletDataOptions> }>(
  '@/components/dashboard/dashlets/*.tsx',
  { eager: true }
);

export const dashletMap: Record<string, Omit<DashletMeta, 'name'>> = {};

for (const path in dashletModules) {
  const mod = dashletModules[path];
  dashletMap[mod.meta.name] = {
    title: mod.meta.title,
    description: mod.meta.description,
    icon: mod.meta.icon,
    component: mod.default,
  };
}
