export type dashboard = {
  id: number;
  user_id: number;
  title: string;
  icon: string;
  range: string;
  refresh_rate: number;
  dashlets: dashlet[];
};

export type dashlet = {
  id: number;
  dashboard_id: number;
  title: string;
  description: string;
  x: number;
  y: number;
  width: number;
  height: number;
  data_options: DashletDataOptions;
  vis_options: DashletVisOptions;
};

export type DashletDataOptions = {
  type: 'source' | 'sources' | 'talkers' | 'scheduledScan';
  range: string;
  isExporting?: boolean;
  single_source_data_options?: SingleSourceDataOptions;
  multi_source_data_options?: MultiSourceDataOptions;
  top_talker_data_options?: TopTalkerDataOptions;
  scheduled_scan_data_options?: ScheduledScanDataOptions;
};

type ScheduledScanDataOptions = {
  scheduled_scan_id: number;
  metrics: string[];
};

type MultiSourceDataOptions = {
  metric: string;
  sources: SourceDataOption[];
};

type SourceDataOption = {
  source_id: number;
  color: number;
  name: string;
};

type SingleSourceDataOptions = {
  source_id: number;
  metrics: string[];
};

type TopTalkerDataOptions = {
  source_id: number;
  num_talkers: number[];
  group_by: string;
  order_by: string;
};

// export type DashletVisOptions = {
//   type: "area" | "bar" | "line" | "pie" | "radial",
//   scale: "auto" | "linear" | "log",
//   area_options?: AreaOptions,
//   bar_options?: BarOptions,
//   line_options?: LineOptions,
// }

// type AreaOptions = {
//   type: "natural" | "linear" | "step";
//   legend: boolean,
//   stacked: "no" | "yes" | "expand";
//   gradient: boolean,
// }

// type BarOptions = {

// }

// type LineOptions = {

// }
