import { SidebarTrigger } from '@/components/ui/sidebar';
import {
  Breadcrumb,
  BreadcrumbItem,
  BreadcrumbLink,
  BreadcrumbList,
  BreadcrumbPage,
  BreadcrumbSeparator,
} from '@/components/ui/breadcrumb';
import { Separator } from '@/components/ui/separator';
import { useLocation, Link } from 'react-router';
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from '@/components/ui/dropdown-menu';
import { useState } from 'react';
import React from 'react';
import { useTranslation } from 'react-i18next';
import { UpdateCheckButton } from '@/components/header/UpdateCheckButton';
import { Search } from '@/components/header/Search';
import SystemStatus from '@/components/header/SystemStatus';

export function Header() {
  const { t } = useTranslation();
  const location = useLocation();
  const crumbs = location.pathname.split('/');
  const [dropdownOpen, setDropdownOpen] = useState(false);

  const items = [
    { title: t('Dashboards'), id: 'dashboards', clickable: false },
    { title: t('Sources'), id: 'sources' },
    { title: t('Groups'), id: 'groups' },
    { title: t('Views'), id: 'views' },
    { title: t('Reports'), id: 'reports' },
    { title: t('Queries'), id: 'queries' },
    { title: t('Alerting'), id: 'alerting' },
    { title: t('Route'), id: 'route' },
    { title: 'Nmap', id: 'nmap' },
    { title: 'Scan', id: 'scan', clickable: false },
    { title: 'Ndiff', id: 'ndiff', clickable: false },
    { title: t('Help'), id: 'help' },
    { title: t('Global Settings'), id: 'globals', parent: 'admin' },
    { title: t('Notification Settings'), id: 'notifications', parent: 'admin' },
    { title: t('Check for Updates'), id: 'updates', parent: 'admin' },
    { title: t('User Management'), id: 'users', parent: 'admin' },
    { title: t('LDAP/AD Integration'), id: 'auth_servers', parent: 'admin' },
    { title: t('Update License'), id: 'license', parent: 'admin' },
    { title: t('System Backup'), id: 'backup', parent: 'admin' },
    { title: t('Profile'), id: 'profile' },
  ];

  const adminItems = items.filter((item) => item.parent === 'admin');

  return (
    <header className="border-border/50 bg-background mt-2 flex h-12 shrink-0 items-center justify-between gap-2 rounded-tl-2xl border-b px-2">
      <div className="flex items-center">
        <SidebarTrigger />
        <Separator orientation="vertical" className="mr-3 ml-2 data-[orientation=vertical]:h-4" />
        <Breadcrumb>
          <BreadcrumbList>
            {crumbs.slice(1).map((crumb, index, arr) => {
              const isLast = index === arr.length - 1;
              const matchedItem = items.find((item) => item.id === crumb);
              const title = matchedItem?.title ?? crumb.charAt(0).toUpperCase() + crumb.slice(1);
              const clickable = matchedItem?.clickable;

              if (index === arr.length - 1) {
                return (
                  <BreadcrumbItem key={index}>
                    <BreadcrumbPage>{title}</BreadcrumbPage>
                  </BreadcrumbItem>
                );
              } else if (crumb === 'admin') {
                return (
                  <React.Fragment key={index}>
                    <BreadcrumbItem>
                      <DropdownMenu open={dropdownOpen} onOpenChange={setDropdownOpen}>
                        <DropdownMenuTrigger>{t('Admin')}</DropdownMenuTrigger>
                        <DropdownMenuContent align="start">
                          {adminItems.map((adminItem) => (
                            <DropdownMenuItem key={adminItem.id} onClick={() => setDropdownOpen(false)}>
                              <Link to={`/admin/${adminItem.id}`}>{adminItem.title}</Link>
                            </DropdownMenuItem>
                          ))}
                        </DropdownMenuContent>
                      </DropdownMenu>
                    </BreadcrumbItem>
                    <BreadcrumbSeparator className="hidden md:block" />
                  </React.Fragment>
                );
              } else {
                // Normal crumb
                return (
                  <React.Fragment key={index}>
                    <BreadcrumbItem className="hidden md:block">
                      <BreadcrumbLink asChild>
                        {clickable !== false ? <Link to={`/${crumb}`}>{title}</Link> : <p>{title}</p>}
                      </BreadcrumbLink>
                    </BreadcrumbItem>
                    {!isLast && <BreadcrumbSeparator className="hidden md:block" />}
                  </React.Fragment>
                );
              }
            })}
          </BreadcrumbList>
        </Breadcrumb>
      </div>
      <div className="flex items-center gap-2">
        <UpdateCheckButton />
        <Search />
        <SystemStatus />
        {/* <NotificationIndicator /> */}
      </div>
    </header>
  );
}
