import { AlertCircle } from 'lucide-react';
import { useUpdateCheck } from '@/components/header/queries';
import { Button } from '../ui/button';
import { useTranslation } from 'react-i18next';

export function UpdateCheckButton() {
  const { t } = useTranslation();
  const { data: updateData } = useUpdateCheck();

  if (!updateData?.update_available) return null;

  return (
    <a
      href={`https://www.nagios.com/checkforupdates/?product=nagiosnetworkanalyzer&version=${updateData.current_version}`}
      target="_blank"
    >
      <Button variant="secondary" size="sm">
        <AlertCircle />
        {t('Update Available')}
      </Button>
    </a>
  );
}
