export type UpdateCheck = {
  update_available: number;
  update_version?: string;
  current_version?: string;
};

export type SuggestReturn = {
  url: string;
  value: string;
  category: string;
  label: string;
};

export type SuggestData = {
  url: string;
  value: string;
  label: string;
};

export type SearchDataType = {
  [key: string]: Array<SuggestData>;
};

export type CPUStatus = {
  cpu_usage: number;
};

export type MemoryStatus = {
  used_percent: number;
  swap_percent: number;
};

export type DiskStatus = {
  filesystem: number;
  size: number;
  used: number;
  available: number;
  percent: number;
};
