import { Link } from 'react-router-dom';
import { PageSeparator } from '@/components/Page';
import { IntegrationNotInstalledProps } from './types';
import { Button } from '../ui/button';

export function IntegrationNotInstalled({ name, description, bullets, link, t }: IntegrationNotInstalledProps) {
  return (
    <>
      <h3 className="text-lg">{name}</h3>
      <PageSeparator />
      <div className="flex flex-1 flex-col justify-between">
        <p className="text-lg">{t(description)}</p>
        <div>
          <p className="mb-2 text-lg font-medium">{t('Key benefits')}:</p>
          <ul className="list-inside list-disc space-y-2">
            {bullets.map((bullet, index) => (
              <li key={index}>{t(bullet)}</li>
            ))}
          </ul>
        </div>
        <p>
          <Link className="text-primary" to={link}>
            <Button>{t(`Install ${name}`)}</Button>
          </Link>
          {/* {t(`for installation instructions and to get started with ${name}.`)} */}
        </p>
      </div>
    </>
  );
}
