import { Button } from '@/components/ui/button';
import { useNavigate } from 'react-router-dom';
import { useTranslation } from 'react-i18next';

export default function NmapNotInstalled() {
  const navigate = useNavigate();
  const { t } = useTranslation();

  return (
    <div className="flex h-full w-full flex-col items-center justify-center">
      <div className="mb-6 text-2xl font-bold">{t('Nmap Not Installed')}</div>
      <Button type="button" onClick={() => navigate('/nmap')}>
        {t('Install Nmap')}
      </Button>
    </div>
  );
}
