import { useDeleteNdiffs } from '@/components/nmap/ndiffs/queries';
import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogCancel,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
  AlertDialogTrigger,
} from '@/components/ui/alert-dialog';
import React from 'react';
import { useTranslation } from 'react-i18next';

export default function DeleteNdiffDialog({
  ids,
  children,
  open,
  onOpenChange,
}: {
  ids: number[];
  children?: React.ReactNode;
  open?: boolean;
  onOpenChange?: (open: boolean) => void;
}) {
  const { t } = useTranslation();
  const deleteNdiff = useDeleteNdiffs();

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      <AlertDialogTrigger asChild>{children}</AlertDialogTrigger>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle>
            {' '}
            {ids.length > 1 ? t('Confirm Ndiffs Deletion') : t('Confirm Ndiff Deletion')}
          </AlertDialogTitle>
          <AlertDialogDescription>
            {ids.length > 1
              ? t('Are you sure you want to delete these Ndiffs?')
              : t('Are you sure you want to delete this Ndiff?')}
          </AlertDialogDescription>
        </AlertDialogHeader>
        <AlertDialogFooter>
          <AlertDialogCancel>{t('Cancel')}</AlertDialogCancel>
          <AlertDialogAction onClick={() => deleteNdiff.mutate(ids)}>{t('Delete')}</AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
}
