import { useTranslation } from 'react-i18next';
import InfoCard from '@/components/ui/InfoCard';
import { Card, CardContent } from '@/components/ui/card';
import { Hash, Scan } from 'lucide-react';
import { Skeleton } from '@/components/ui/skeleton';
import { useGetNmapOverview } from '@/components/nmap/overview/queries';
import { useNavigate } from 'react-router-dom';
import { NmapScansOverTimeBarChart } from '@/components/nmap/overview/ScansOverTimeBarChart';
import { ScheduledScansChart } from '@/components/nmap/overview/ScheduledScansChart';

export default function Overview() {
  const { t } = useTranslation();
  const { data: overviewData, isLoading: isLoadingOverview } = useGetNmapOverview();
  const navigate = useNavigate();

  if (isLoadingOverview) {
    return (
      <Card>
        <CardContent>
          <div className="mb-4 flex w-full gap-4">
            <Skeleton className="h-45 w-1/2" />
            <Skeleton className="h-45 w-1/2" />
          </div>
          <div className="flex">
            <Skeleton className="mr-4 h-80 w-2/5" />
            <Skeleton className="ml-4 h-80 w-3/5" />
          </div>
        </CardContent>
      </Card>
    );
  }

  return (
    <Card>
      <CardContent>
        <div className="flex w-full flex-col gap-4">
          <div className="grid grid-cols-1 gap-4 lg:grid-cols-2 xl:grid-cols-4">
            <InfoCard
              header={t('Total Scans')}
              data={overviewData?.total_scans.toString() || '0'}
              icon={<Hash />}
              tooltip={t('Total number of Scans.')}
            />
            <InfoCard
              header={t('Total Ndiffs')}
              data={overviewData?.total_ndiffs || '0'}
              icon={<Hash />}
              tooltip={t('Total number of Ndiffs.')}
            />
            <InfoCard
              header={t('Total Scheduled Scans')}
              data={overviewData?.total_scheduled_scans || '0'}
              icon={<Hash />}
              tooltip={t('Total number of Scheduled Scans.')}
            />
            <InfoCard
              className={`transition-transform ${overviewData?.most_recent_scan?.id ? 'hover:bg-accent cursor-pointer rounded-xl hover:scale-102 hover:shadow-lg' : 'pointer-events-none opacity-50'}`}
              onClick={() => navigate(`/nmap/scan/${overviewData?.most_recent_scan?.id}`)}
              header={t('Most Recent Scan')}
              data={overviewData?.most_recent_scan?.title || '0'}
              icon={<Scan />}
              tooltip={t('The most recent scan.')}
            />
          </div>
          <div className="grid grid-cols-6 gap-4">
            <div className="col-span-3">
              <NmapScansOverTimeBarChart data={overviewData?.scan_in_last7days ?? []} />
            </div>
            <div className="col-span-3">
              <ScheduledScansChart data={overviewData?.scheduled_scans ?? []} />
            </div>
          </div>
        </div>
      </CardContent>
    </Card>
  );
}
