import { nmapOptionField } from '@/components/nmap/profiles/types';

// Defines how to build a form for Nmap options
export const NMAP_OPTION_SECTIONS: { section: string; fields: nmapOptionField[] }[] = [
  {
    section: 'Target Specification',
    fields: [
      {
        key: 'targets',
        label: 'Targets',
        type: 'input',
        tooltip: 'Targets for the scan (hostnames, IPs, networks, etc.)',
        placeholder: 'nmap.org 192.168.0.0/24',
      },
      // { key: "-iL", label: "Input from list", type: "input", tooltip: "Input from list of hosts/networks", placeholder: "inputfilename" },
      {
        key: '-iR',
        label: 'Choose random targets',
        type: 'input',
        tooltip:
          'Choose targets at random. This tells Nmap how many IPs to generate. 0 is used for a never-ending scan.',
        placeholder: 'Number of hosts',
      },
      {
        key: '--exclude',
        label: 'Exclude hosts/networks',
        type: 'input',
        tooltip: 'List of targets to exclude from the scan.',
        placeholder: 'Host1, Host2, ...',
      },
      // { key: "--excludefile", label: "Exclude list from file", type: "input", tooltip: "Exclude list from file", placeholder: "exclude_file" },
    ],
  },
  {
    section: 'Host Discovery',
    fields: [
      {
        key: '-sL',
        label: 'List Scan',
        type: 'checkbox',
        tooltip: 'Lists targets that can be scanned. Includes reverse DNS names when available.',
      },
      {
        key: '-sn',
        label: 'Ping Scan',
        type: 'checkbox',
        tooltip:
          'Skip the port scanning phase. Other phases such as host discovery, script scan, and traceroute may still run.',
      },
      {
        key: '-Pn',
        label: 'Treat all hosts as online',
        type: 'checkbox',
        tooltip:
          "Don't ping before scanning. Nmap will not check if targets are up before scanning them. Scans each given target.",
      },
      {
        key: '-PS',
        label: 'TCP SYN discovery',
        type: 'input',
        tooltip:
          'Send SYN probes to verify if the targets are reachable. Enter a list of ports manually or leave blank to use the default setting.',
        placeholder: 'protocol list',
      },
      {
        key: '-PA',
        label: 'TCP ACK discovery',
        type: 'input',
        tooltip:
          'Send ACK probes to verify if the targets are reachable. Enter a list of ports manually or leave blank to use the default setting.',
        placeholder: 'protocol list',
      },
      {
        key: '-PU',
        label: 'UDP discovery',
        type: 'input',
        tooltip:
          'Send UDP probes to verify if the targets are reachable. Enter a list of ports manually or leave blank to use the default setting.',
        placeholder: 'protocol list',
      },
      {
        key: '-PY',
        label: 'SCTP discovery',
        type: 'input',
        tooltip:
          'Send SCTP INIT packets to verify if the targets are reachable. Enter a list of ports manually or leave blank to use the default setting.',
        placeholder: 'protocol list',
      },
      {
        label: 'ICMP Discovery Type',
        type: 'select',
        tooltip: 'Choose the type of ICMP discovery probe to check if targets are up.',
        options: [
          {
            key: '-PE',
            label: 'ICMP echo request (-PE)',
            tooltip: 'Send an ICMP echo request (ping) to determine if the targets are up.',
          },
          {
            key: '-PP',
            label: 'ICMP timestamp request (-PP)',
            tooltip: 'Send an ICMP timestamp request to check if the targets are up.',
          },
          {
            key: '-PM',
            label: 'ICMP netmask request (-PM)',
            tooltip: 'Send an ICMP address mask request to check if the targets are up.',
          },
        ],
      },
      {
        key: '-PO',
        label: 'IP Protocol Ping',
        type: 'input',
        tooltip:
          'Send one or more raw IP protocol probes to see if the targets are up. Specify a list of protocols or leave blank to use the default list.',
        placeholder: 'protocol list',
      },
      {
        label: 'DNS Resolution',
        type: 'select',
        tooltip: 'Control how DNS resolution is handled during scans.',
        options: [
          {
            key: '-n',
            label: 'Never do DNS resolution (-n)',
            tooltip: 'Disable reverse DNS resolution. This can significantly speed up scanning.',
          },
          {
            key: '-R',
            label: 'Always resolve (-R)',
            tooltip: 'Always perform DNS resolution for target IP addresses.',
          },
        ],
      },
      {
        key: '--dns-servers',
        label: 'Custom DNS servers',
        type: 'input',
        tooltip:
          'Specify one or more custom DNS servers to use for name resolution. Separate multiple servers with commas.',
        placeholder: 'Server1, Server2,...',
      },
      {
        key: '--system-dns',
        label: "Use OS's DNS resolver",
        type: 'checkbox',
        tooltip: "Use the operating system's default DNS resolver instead of custom settings.",
      },
      {
        key: '--traceroute',
        label: 'Trace hop path',
        type: 'checkbox',
        tooltip:
          'Trace the network path (hops) to each target after scanning. Works with all scan types except connect scan (-sT) and idle scan (-sI).',
      },
    ],
  },
  {
    section: 'Scan Techniques',
    fields: [
      {
        label: 'TCP Scan',
        type: 'select',
        options: [
          {
            key: '-sS',
            label: 'TCP SYN Scan (-sS)',
            tooltip:
              "Sends probes with the SYN flag set. The most commonly used and generally useful scan type. Known as a 'stealth' scan because it avoids completing the TCP handshake.",
          },
          {
            key: '-sT',
            label: 'TCP Connect Scan (-sT)',
            tooltip:
              "Uses the system's connect() call to establish full TCP connections. Less stealthy than SYN scan but works without raw packet privileges and supports IPv6 networks.",
          },
          {
            key: '-sA',
            label: 'TCP ACK Scan (-sA)',
            tooltip:
              "Sends probes with the ACK flag set. Determines whether ports are 'filtered' or 'unfiltered'. Useful for mapping firewall rules.",
          },
          {
            key: '-sW',
            label: 'TCP Window Scan (-sW)',
            tooltip:
              "Similar to ACK scan but leverages TCP window size behavior on some systems to differentiate open ports from closed ones, rather than always printing 'unfiltered' when a RST packet is returned.",
          },
          {
            key: '-sM',
            label: 'TCP Maimon Scan (-sM)',
            tooltip:
              "Sends probes with both FIN and ACK flags set. On certain BSD-based systems, this can distinguish between 'closed' and 'open|filtered' ports.",
          },
          {
            key: '-sN',
            label: 'TCP Null Scan (-sN)',
            tooltip:
              "Sends probes with no TCP flags set. Can differentiate between 'closed' and 'open|filtered' ports on some systems.",
          },
          {
            key: '-sF',
            label: 'TCP FIN Scan (-sF)',
            tooltip:
              "Sends probes with the FIN flag set. Helps identify 'closed' and 'open|filtered' ports on systems that support this behavior.",
          },
          {
            key: '-sX',
            label: 'TCP Xmas Scan (-sX)',
            tooltip:
              "Sends probes with FIN, PSH, and URG flags set, making the packet 'light up' like a Christmas tree. Differentiates between 'closed' and 'open|filtered' ports on certain systems.",
          },
        ],
      },
      {
        key: '-sU',
        label: 'UDP Scan',
        type: 'checkbox',
        tooltip:
          'Scan UDP ports. UDP scanning is generally slower and less reliable than TCP, and is often ignored by security auditors.',
      },
      {
        key: '--scanflags',
        label: 'Custom TCP scan flags',
        type: 'input',
        tooltip: 'Specify custom TCP flags for scanning (e.g., SYN, ACK, FIN, etc.).',
        placeholder: 'Flags',
      },
      {
        key: '-sI',
        label: 'Idle scan',
        type: 'input',
        tooltip:
          "Perform a stealth scan by spoofing packets through a 'zombie' host, so the target does not see packets from your IP. Nmap will verify that the zombie meets required conditions before scanning.",
        placeholder: 'Zombie Host:Probe Port',
      },
      {
        label: 'SCTP Scan',
        type: 'select',
        options: [
          {
            key: '-sY',
            label: 'SCTP INIT scan (-sY)',
            tooltip:
              'SCTP is a layer 4 protocol used mostly for telephony related applications.  This is the SCTP equivalent of a TCP SYN stealth scan.',
          },
          {
            key: '-sZ',
            label: 'SCTP COOKIE-ECHO scan (-sZ)',
            tooltip: 'SCTP is a layer 4 protocol used mostly for telephony related applications.',
          },
        ],
      },
      {
        key: '-sO',
        label: 'IP protocol scan',
        type: 'checkbox',
        tooltip: 'Scan which IP protocols (TCP, ICMP, IGMP, etc.) are supported by the target hosts.',
      },
      {
        key: '-b',
        label: 'FTP bounce scan',
        type: 'input',
        tooltip:
          'Use an FTP server to port scan other hosts by sending a file to each interesting port of a target host.',
        placeholder: 'FTP relay host',
      },
    ],
  },
  {
    section: 'Port Specification and Scan Order',
    fields: [
      {
        key: '-p',
        label: 'Port ranges',
        type: 'input',
        tooltip: 'Specify which ports you want to scan. This overrides the default.',
        placeholder: '1-65535',
      },
      {
        key: '--exclude-ports',
        label: 'Exclude ports',
        type: 'input',
        tooltip: 'Exclude the specified ports from being scanned.',
        placeholder: '1-65535',
      },
      {
        key: '-F',
        label: 'Fast mode',
        type: 'checkbox',
        tooltip:
          'Scan only the ports listed in the nmap-services file (or the nmap-protocols file when using -sO) to speed up scanning.',
      },
      {
        key: '-r',
        label: 'Scan ports sequentially',
        type: 'checkbox',
        tooltip: "Don't randomize the order ports are scanned in.",
      },
      {
        key: '--top-ports',
        label: 'Top ports',
        type: 'input',
        tooltip: 'Scan the <number> most common ports',
        placeholder: 'Number',
      },
      {
        key: '--port-ratio',
        label: 'Port ratio',
        type: 'input',
        tooltip: 'Scan ports more common than <ratio>. The ratio is a decimal between 0.0 and 1.0.',
        placeholder: 'ratio',
      },
    ],
  },
  {
    section: 'Service/Version Detection',
    fields: [
      {
        key: '-sV',
        label: 'Version detection',
        type: 'checkbox',
        tooltip: 'Probe open ports to determine the version number of services.',
      },
      {
        key: '--version-intensity',
        label: 'Version intensity',
        type: 'select',
        tooltip: 'Set from 0 (light) to 9 (try all probes)',
        options: [
          { key: '0', label: '0 (light)' },
          { key: '1', label: '1' },
          { key: '2', label: '2' },
          { key: '3', label: '3' },
          { key: '4', label: '4' },
          { key: '5', label: '5' },
          { key: '6', label: '6' },
          { key: '7', label: '7' },
          { key: '8', label: '8' },
          { key: '9', label: '9 (try all probes)' },
        ],
      },
      {
        key: '--version-light',
        label: 'Version light',
        type: 'checkbox',
        tooltip: 'Limit to most likely probes (intensity 2)',
      },
      {
        key: '--version-all',
        label: 'Version all',
        type: 'checkbox',
        tooltip: 'Try every single probe (intensity 9)',
      },
      {
        key: '--version-trace',
        label: 'Version trace',
        type: 'checkbox',
        tooltip: 'Show detailed version scan activity',
      },
    ],
  },
  // {
  //   section: "Script Scan",
  //   fields: [
  //     {
  //       key: "-sC",
  //       label: "Default scripts",
  //       type: "checkbox",
  //       tooltip: "equivalent to --script=default",
  //     },
  //     {
  //       key: "--script",
  //       label: "Script(s)",
  //       type: "input",
  //       tooltip: "Comma separated list of scripts or categories",
  //       placeholder: "Lua scripts",
  //     },
  //     {
  //       key: "--script-args",
  //       label: "Script args",
  //       type: "input",
  //       tooltip: "Provide arguments to scripts",
  //       placeholder: "n1=v1,[n2=v2,...]",
  //     },
  //     {
  //       key: "--script-args-file",
  //       label: "Script args file",
  //       type: "input",
  //       tooltip: "Provide NSE script args in a file",
  //       placeholder: "filename",
  //     },
  //     {
  //       key: "--script-trace",
  //       label: "Script trace",
  //       type: "checkbox",
  //       tooltip: "Show all data sent and received",
  //     },
  //     {
  //       key: "--script-updatedb",
  //       label: "Update script DB",
  //       type: "checkbox",
  //       tooltip: "Update the script database",
  //     },
  //     {
  //       key: "--script-help",
  //       label: "Script help",
  //       type: "input",
  //       tooltip: "Show help about scripts",
  //       placeholder: "Lua scripts",
  //     },
  //   ]
  // },
  {
    section: 'OS Detection',
    fields: [
      {
        key: '-O',
        label: 'OS detection',
        type: 'checkbox',
        tooltip: 'Attempt to discover the operating system running on hosts.',
      },
      {
        key: '--osscan-limit',
        label: 'OS scan limit',
        type: 'checkbox',
        tooltip: 'Limit OS detection to only promising targets.',
      },
      {
        key: '--osscan-guess',
        label: 'OS scan guess',
        type: 'checkbox',
        tooltip: 'Guess the operating system of hosts more aggressively.',
      },
    ],
  },
  {
    section: 'Timing and Performance',
    fields: [
      {
        key: '-T',
        label: 'Timing template',
        type: 'select',
        tooltip: 'Set the timing template (higher is faster).',
        options: [
          { key: '0', label: '0 (Paranoid)' },
          { key: '1', label: '1 (Sneaky)' },
          { key: '2', label: '2 (Polite)' },
          { key: '3', label: '3 (Normal)' },
          { key: '4', label: '4 (Aggressive)' },
          { key: '5', label: '5 (Insane)' },
        ],
      },
      {
        key: '--min-hostgroup',
        label: 'Min hostgroup',
        type: 'input',
        tooltip: 'Scan at least this many hosts in parallel.',
        placeholder: 'Size',
      },
      {
        key: '--max-hostgroup',
        label: 'Max hostgroup',
        tooltip: 'Scan no more than this many hosts in parallel.',
        type: 'input',
        placeholder: 'Size',
      },
      {
        key: '--min-parallelism',
        label: 'Min parallelism',
        type: 'input',
        tooltip:
          'Attempt to maintain at least this number of probes outstanding during a scan. Setting higher than 1 can speed up scans on slow or poorly performing hosts or networks.',
        placeholder: 'Number of probes',
      },
      {
        key: '--max-parallelism',
        label: 'Max parallelism',
        type: 'input',
        tooltip:
          'Do not allow more than this number of probes to be outstanding at a time. Setting to 1 ensures Nmap sends only one probe at a time per host.',
        placeholder: 'Number of probes',
      },
      {
        key: '--min-rtt-timeout',
        label: 'Min RTT timeout',
        type: 'input',
        tooltip:
          "Wait at least this long for a probe response before giving up or retransmitting. Time is in seconds by default, or can use 'ms' (milliseconds), 's' (seconds), 'm' (minutes), or 'h' (hours).",
        placeholder: 'Time',
      },
      {
        key: '--max-rtt-timeout',
        label: 'Max RTT timeout',
        type: 'input',
        tooltip:
          'Wait no longer than this for a probe response before giving up or retransmitting. Time format is the same as for minimum RTT timeout.',
        placeholder: 'Time',
      },
      {
        key: '--initial-rtt-timeout',
        label: 'Initial RTT timeout',
        type: 'input',
        tooltip:
          'Set the initial estimate for round-trip time. Providing a suitable value can speed up scans on networks with known performance characteristics.',
        placeholder: 'Time',
      },
      {
        key: '--max-retries',
        label: 'Max retries',
        type: 'input',
        tooltip: 'Retry sending a probe to each port up to this number of times before giving up.',
        placeholder: 'Number of tries',
      },
      {
        key: '--host-timeout',
        label: 'Host timeout',
        type: 'input',
        tooltip: 'Give up on a target after this long.',
        placeholder: 'Time',
      },
      {
        key: '--scan-delay',
        label: 'Scan delay',
        type: 'input',
        tooltip: 'Adjust the delay between probes.',
        placeholder: 'Time',
      },
      {
        key: '--max-scan-delay',
        label: 'Max scan delay',
        type: 'input',
        tooltip: 'Adjust the delay between probes.',
        placeholder: 'Time',
      },
      {
        key: '--min-rate',
        label: 'Min rate',
        type: 'input',
        tooltip: 'Send packets no slower than <number> packets per second.',
        placeholder: 'Number',
      },
      {
        key: '--max-rate',
        label: 'Max rate',
        type: 'input',
        tooltip: 'Send packets no faster than <number> packets per second.',
        placeholder: 'Number',
      },
    ],
  },
  {
    section: 'Firewall Evasion and Spoofing',
    fields: [
      {
        key: '-f',
        label: 'Fragment packets',
        type: 'checkbox',
        tooltip: 'Fragment packets into smaller pieces to bypass certain firewalls and packet filters.',
      },
      {
        key: '--mtu',
        label: 'MTU',
        type: 'input',
        tooltip: 'Specify the maximum transmission unit (MTU) for fragmenting packets.',
        placeholder: 'Value',
      },
      {
        key: '-D',
        label: 'Decoy',
        type: 'input',
        tooltip:
          "Send fake decoy probes from spoofed addresses to hide your own IP. Provide a comma-separated list of addresses. Use 'RND' for a random address and 'ME' to set your own position.",
        placeholder: 'Decoy1, Decoy2[,ME], ...',
      },
      {
        key: '-S',
        label: 'Spoof source address',
        type: 'input',
        tooltip: 'Send packets using a specified source IP address.',
        placeholder: 'IP Address',
      },
      {
        key: '-e',
        label: 'Network Interface',
        type: 'input',
        tooltip: 'Specify which network interface to send and receive packets on.',
        placeholder: 'Interface',
      },
      {
        key: '--source-port',
        label: 'Source port',
        type: 'input',
        tooltip: 'Send packets from the given source port where possible.',
        placeholder: 'Port number',
      },
      {
        key: '--proxies',
        label: 'Proxies',
        type: 'input',
        tooltip: 'Relay connections through one or more HTTP/SOCKS4 proxies.',
        placeholder: 'URL 1, [URL 2],...',
      },
      {
        key: '--data',
        label: 'Custom payload (hex)',
        type: 'input',
        tooltip: 'Append a custom hexadecimal payload to each packet sent.',
        placeholder: 'Hex string',
      },
      {
        key: '--data-string',
        label: 'Custom payload (ASCII)',
        type: 'input',
        tooltip: 'Append a custom ASCII string to each packet sent.',
        placeholder: 'String',
      },
      {
        key: '--data-length',
        label: 'Random data length',
        type: 'input',
        tooltip: 'Append random data of the specified length to each packet.',
        placeholder: 'Number',
      },
      {
        key: '--ip-options',
        label: 'IP options',
        type: 'input',
        tooltip: 'Send packets with the specified ip options',
        placeholder: 'options',
      },
      {
        key: '--ttl',
        label: 'Time-to-live',
        type: 'input',
        tooltip: 'Set the IP Time-to-Live field for outgoing packets.',
        placeholder: 'Value',
      },
      {
        key: '--spoof-mac',
        label: 'Spoof MAC address',
        type: 'input',
        tooltip: 'Spoof the MAC address. You can specify an exact address, a prefix, or a vendor name.',
        placeholder: 'MAC address/ Prefix / Vendor name',
      },
      {
        key: '--badsum',
        label: 'Bogus checksum',
        type: 'checkbox',
        tooltip: 'Send packets with an invalid TCP/UDP/SCTP checksum to evade some packet filters.',
      },
    ],
  },
  {
    section: 'Miscellaneous',
    fields: [
      {
        key: '-6',
        label: 'IPv6 Scanning',
        type: 'checkbox',
        tooltip: 'Enable IPv6 scanning.',
      },
      {
        key: '-A',
        label: 'Aggressive scan',
        type: 'checkbox',
        tooltip:
          'Enables OS detection (-O), version detection (-sV), script scanning (-sC), and traceroute (--traceroute).',
      },
      {
        key: '--datadir',
        label: 'Custom data dir',
        type: 'input',
        tooltip: 'Specify custom Nmap data file location',
        placeholder: 'Directory name',
      },
      {
        key: '--send-eth',
        label: 'Send using raw ethernet frames',
        type: 'checkbox',
        tooltip: 'Sends packets at the Ethernet layer using raw frames instead of standard IP packets.',
      },
      {
        key: '--send-ip',
        label: 'Send using IP packets',
        type: 'checkbox',
        tooltip: 'Default behavior. Sends packets using the standard IP layer instead of raw Ethernet frames.',
      },
      {
        key: '-V',
        label: 'Print Nmap version number',
        type: 'checkbox',
      },
    ],
  },
];
