import { ScheduleParameters, ScheduleType } from '@/components/scheduling/types';
import i18n from 'i18next';

export const defaultScheduleParameters: ScheduleParameters = {
  x: '1',
  minute: '0',
  weekday: '0',
  day: '1',
  month: '1',
  time: '00:00',
  cron: '* * * * *',
};

export function getDayOfMonthWithSuffix(day: number | string): string {
  const n = typeof day === 'string' ? parseInt(day, 10) : day;
  if (isNaN(n)) return String(day);
  const j = n % 10,
    k = n % 100;
  if (j === 1 && k !== 11) return `${n}st`;
  if (j === 2 && k !== 12) return `${n}nd`;
  if (j === 3 && k !== 13) return `${n}rd`;
  return `${n}th`;
}

export function getScheduleTypeLabel(type: ScheduleType): string {
  const scheduleTypeOptions: Record<ScheduleType, string> = {
    every: i18n.t('Every X Minutes'),
    hourlyAt: i18n.t('Hourly'),
    dailyAt: i18n.t('Daily'),
    weeklyOn: i18n.t('Weekly'),
    monthlyOn: i18n.t('Monthly'),
    yearlyOn: i18n.t('Yearly'),
    cron: i18n.t('Custom Cron Expression'),
  };
  return scheduleTypeOptions[type];
}
